/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fileobj.h
 * @brief %jp{t@CIuWFNg}
 *
 * %jp{t@CfBXNv^Ƃċ@\NX}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__fileobj_h__
#define __HOS__fileobj_h__


#include "system/file/file.h"
#include "system/handle/handleobj.h"

struct c_drvobj;

/* t@CIuWFNgNX{\bhe[u */
typedef struct t_fileobj_methods
{
	T_HANDLEOBJ_METHODS	HandlObjMethods;	/* nhIuWFNgp */
} T_FILEOBJ_METHODS;


/* t@CuWFNg{NX` */
typedef struct c_fileobj
{
	C_HANDLEOBJ		HandleObj;				/* nhIuWFNgp */

	struct c_drvobj	*pDrvObj;				/* hCoւ̎Q */

	int				iMode;					/* I[ṽ[h */
	void			*pReadBuf;				/* [hobt@ */
	void			*pWriteBuf;				/* Cgobt@ */	
} C_FILEOBJ;


#include "drvobj.h"


/* nhϊ */
#define FILE_HANDLE2OBJ(hFile)		((C_FILEOBJ *)(hFile))


#ifdef __cplusplus
extern "C" {
#endif

HANDLE FileObj_Create(struct c_drvobj *pDrvObj, int iMode);
void   FileObj_Delete(HANDLE Handle);

#define FileObj_GetMode(self)		((self)->iMode)

#ifdef __cplusplus
}
#endif




#endif	/* __HOS__file_h__ */


/* end of file */
