/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  ostimer.c
 * @brief %jp{OS^C}}%en{OS timer}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "kernel.h"
#include "ostimer.h"
#include "regs_sh7144.h"
#include "system/sysapi/sysapi.h"


#define PERIPHERAL_CLOCK		(24000000UL)				/**< %jp{ytFNbN(24MHz)} */


static void OsTimer_Isr(VPARAM Param);				/**< %jp{^C}݃nh} */


/** %jp{OSp^C}[`} */
void OsTimer_Initialize(void)
{
	/* %jp{݃T[rX[`o^} */
	SysIsr_Create(144, OsTimer_Isr, (VPARAM)0);
	
	/* %jp{^C}Jn} */
	*REG_STANDBY_MSTCR2 &= 0xefff;
	*REG_CMT_CMSTR  &= 0xfffe;								/* %jp{~} */
	*REG_CMT0_CMCNT  = 0x0000;								/* %jp{JE^NA} */
	*REG_CMT0_CMCOR  = (PERIPHERAL_CLOCK / 128) / 1000;		/* %jp{1msɐݒ} */
	*REG_CMT0_CMCSR  = 0x0042;								/* %jp{128ɐݒ} */
	*REG_CMT_CMSTR  |= 0x0001;								/* %jp{Jn} */
	
	/* %jp{݋} */
	*REG_INTC_IPRG = ((*REG_INTC_IPRG & 0xff0f) | 0x0010);
}


/** %jp{^C}݃nh} */
void OsTimer_Isr(VPARAM Param)
{
	*REG_CMT0_CMCSR &= 0xff7f;
	
	SysTim_Signal(1000000UL);
}


/* end of file */
