/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  valmemheap_free.c
 * @brief %jp{σTCYq[vNX}%en{variable size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "valmemheap_local.h"



/** %jp{̉} */
void ValMemHeap_Free(void *pMemHeap, void *pMem)
{
	C_VALMEMHEAP		*self;
	T_VALMEMHEAP_MEMBLK *mblk;
	T_VALMEMHEAP_MEMBLK *mblktmp;
	T_VALMEMHEAP_MEMBLK *mblknext;
	MEMSIZE				MemBlockSize;


	/* upper cast */
	self = (C_VALMEMHEAP *)pMemHeap;
	
	/* %jp{|C^͈̓`FbN} */
	if ( pMem < (void *)self->pMemBase || pMem >= (void *)((char *)self->pMemBase + self->MemSize) )
	{
		return;
	}

	/* %jp{ubÑTCY𒲐} */
	MemBlockSize = ValMemHeap_GetMemBlockSize(self);

	/* %jp{ubNʒu擾} */
	mblk = (T_VALMEMHEAP_MEMBLK *)((char *)pMem - MemBlockSize);

	/* %jp{p[^[`FbN} */
	if ( mblk->iFlag != VALMEMHEAP_USING )	/* %jp{gpŖ} */
	{
		return;
	}

	/* %jp{tO𖢎gpɐݒ} */
	mblk->iFlag = VALMEMHEAP_FREE;
	
	/* %jp{̃ubN`FbN} */
	mblktmp = (T_VALMEMHEAP_MEMBLK *)((char *)pMem + mblk->Size);
	if ( mblktmp->iFlag == VALMEMHEAP_FREE )
	{
		/* %jp{̃ubNgpȂ猋} */
		mblknext = (T_VALMEMHEAP_MEMBLK *)((char *)mblktmp + mblktmp->Size + MemBlockSize);
		mblknext->pPrev = mblk;
		mblk->Size += mblktmp->Size + MemBlockSize;
	}
	
	/* %jp{ÕubN`FbN} */
	if ( mblk->pPrev != NULL )
	{
		mblktmp = mblk->pPrev;
		if ( mblktmp->iFlag == VALMEMHEAP_FREE )
		{
			/* %jp{ÕubNgpȂ猋} */
			mblknext = (T_VALMEMHEAP_MEMBLK *)((char *)mblk + mblk->Size + MemBlockSize);
			mblknext->pPrev = mblktmp;
			mblktmp->Size += mblk->Size + MemBlockSize;
		}
	}
}


/* end of file */
