/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  valmemheap_alloc.c
 * @brief %jp{σTCYq[vNX}%en{variable size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "valmemheap_local.h"



/** %jp{MemHeapNX z֐e[u}%en{MemHeap class virtual function table} */
const static T_MEMHEAP_METHODS ValMemHeap_Methods =
	{
		ValMemHeap_Alloc,			/**< ̊蓖 */
		ValMemHeap_ReAlloc,			/**< ̍Ċ蓖 */
		ValMemHeap_Free,			/**< ̊J */
		ValMemHeap_GetSize,			/**< ̃TCY擾 */
		ValMemHeap_GetAlign,		/**< ACg̎擾 */
		ValMemHeap_AlignSize,		/**< TCYACgPʂɊg */
		ValMemHeap_IsMember,		/**< q[vɑĂ邩`FbN */
	};



/** %jp{RXgN^} */
void ValMemHeap_Constructor(C_VALMEMHEAP *self, void *pMemBase, MEMSIZE MemSize, int AlignSize)
{
	T_VALMEMHEAP_MEMBLK *pBlkLast;
	MEMSIZE				MemBlockSize;
	
	
	/* %jp{eNXRXgN^} */
	MemHeap_Constructor(&self->MemHeap, &ValMemHeap_Methods);

	/* %jp{TCỸACg𒲐} */
	MemSize = MemSize & ~(AlignSize - 1);
	
	/* oϐݒ */
	self->pMemBase  = (T_VALMEMHEAP_MEMBLK *)pMemBase;		/**< %jp{擪ubÑAhX} */
	self->MemSize   = MemSize;								/**< %jp{TCY} */
	self->AlignMask = AlignSize - 1;						/**< %jp{ACgTCY} */

	/* %jp{ubÑTCY𒲐} */
	MemBlockSize = ValMemHeap_GetMemBlockSize(self);

	/* %jp{TCY`FbN} */
	if ( MemSize <= MemBlockSize * 2 )
	{
		self->pMemBase = NULL;
		return;
	}
	
	/* %jp{I[ʒuɔԐlݒ} */
	pBlkLast = (T_VALMEMHEAP_MEMBLK *)((char *)self->pMemBase + MemSize - MemBlockSize);
	
	/* %jp{Ŝ󂫗̈ɐݒ} */
	self->pMemBase->pPrev = NULL;
	self->pMemBase->Size = MemSize - (MemBlockSize * 2);
	self->pMemBase->iFlag = VALMEMHEAP_FREE;
	
	/* %jp{I[̔Ԑl𗘗pɐݒ} */
	pBlkLast->pPrev = NULL;
	pBlkLast->Size  = 0;
	pBlkLast->iFlag = VALMEMHEAP_USING;
}


/* end of file */
