/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  streambuf.h
 * @brief %jp{Xg[f[^pobt@NX}
 *
 * Copyright (C) 2002-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "streambuf_local.h"


/** f[^̑M */
unsigned int StreamBuf_SendData(C_STREAMBUF *self, const void *pData, unsigned int uiSize)
{
	void 			*pBuf;				/* obt@AhX */
	unsigned int	uiBufSize;			/* obt@TCY */
	unsigned int	uiSendSize = 0;		/* MTCY */

	do
	{
		/* Mobt@擾 */
		if ( (uiBufSize = StreamBuf_GetBuf(self, &pBuf)) <= 0 )
		{
			break;
		}
		
		/* TCYvZ */
		if ( uiBufSize > uiSize )
		{
			uiBufSize = uiSize;
		}
		
		/* f[^Rs[ */
		memcpy(pBuf, pData, uiBufSize);
		
		/* M */
		StreamBuf_SendBuf(self, uiBufSize);
		
		/* |C^XV */
		pData       = (void *)((char *)pData + uiBufSize);
		uiSize     -= uiBufSize;
		uiSendSize += uiBufSize;
	} while ( uiSize > 0 );
	
	
	return uiSendSize;		/* MTCYԂ */
}


/* end of file */
