/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  packetbuf.h
 * @brief %jp{pPbgf[^pobt@NX}
 *
 * Copyright (C) 2002-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__packetbuf_h__
#define __HOS__packetbuf_h__



/* pPbgobt@NX\ */
typedef struct c_packetbuf
{
	unsigned char			*pubBuf;			/**< obt@̈̐擪AhX */
	unsigned int			uiBufSize;			/**< obt@̈̃TCY */
	volatile unsigned int	uiReturnPoint;		/**< obt@܂Ԃʒu */
	volatile unsigned int	uiHead;				/**< f[^̐擪 */
	volatile unsigned int	uiTail;				/**< f[^̖ */
} C_PACKETBUF;



#ifdef __cplusplus
extern "C" {
#endif

/* ^폜 */
void         PacketBuf_Create(C_PACKETBUF *self, unsigned int uiBufSize, void *pBuf);		/**< RXgN^ */
#define      PacketBuf_Delete(self)		do {} while(0)										/**< fXgN^ */

/* pPbgM */
unsigned int PacketBuf_SendData(C_PACKETBUF *self, const void *pData, unsigned int uiSize);	/**< f[^̑M */
unsigned int PacketBuf_GetBuf(C_PACKETBUF *self, void **ppBuf, unsigned int uiSize);		/**< Mpobt@̎擾(ȃRs[) */
void         PacketBuf_SendBuf(C_PACKETBUF *self, unsigned int uiSize);						/**< obt@̃f[^̑M(ȃRs[) */

/* pPbgM */
unsigned int PacketBuf_RecvData(C_PACKETBUF *self, void *pBuf, unsigned int uiSize);		/**< f[^̎M */
unsigned int PacketBuf_RecvBuf(C_PACKETBUF *self, void **ppBuf);							/**< Mf[^̓obt@̎擾(ȃRs[) */
void         PacketBuf_RelBuf(C_PACKETBUF *self);											/**< Mpobt@̉(ȃRs[) */

/*  */
void         PacketBuf_Clear(C_PACKETBUF *self);											/**< obt@̃NA */


#ifdef __cplusplus
}
#endif



#endif	/* __HOS__packetbuf_local_h__ */


/* end of file */
