/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  list.h
 * @brief %jp{XgNX}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__list_h__
#define __HOS__list_h__


#include "library/container/memheap/memheap.h"


#define LIST_ERR_OK			0
#define LIST_ERR_NG			(-1)
#define LIST_POS_NULL		0

typedef int		LIST_ERR;
typedef void*	LIST_POS;


/* Xg[obt@NX */
typedef struct c_list
{
	C_MEMHEAP	*pMemHeap;		/* p郁I/F */
	void		*pHead;			/* 擪vfւ̃|C^ */
} C_LIST;


#ifdef __cplusplus
extern "C" {
#endif

/* ^폜 */
void      List_Create(C_LIST *self);													/* Xg̐ */
void      List_CreateEx(C_LIST *self, C_MEMHEAP *pMemHeap);									/* Xg̐ */
void      List_Delete(C_LIST *self);													/* Xg̍폜 */

/*  */
LIST_ERR  List_AddTail(C_LIST *self, const void *pData, long lSize);					/* f[^̖ǉ */
LIST_ERR  List_Insert(C_LIST *self, LIST_POS Pos, const void *pData, long lSize);		/* f[^̑} */
LIST_ERR  List_Remove(C_LIST *self, LIST_POS Pos);										/* f[^̍폜 */
void     *List_GetAt(C_LIST *self, LIST_POS Pos);										/* f[^̎Q */

LIST_POS  List_GetHeadPos(C_LIST *self);
LIST_POS  List_GetTailPos(C_LIST *self);
LIST_POS  List_GetNextPos(C_LIST *self, LIST_POS Pos);
LIST_POS  List_GetPrevPos(C_LIST *self, LIST_POS Pos);

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__assocbuf_h__ */

