/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  hashtable_get.c
 * @brief %jp{nbVe[uNX}%en{hash table class}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <string.h>
#include "hashtable_local.h"



/**< %jp{RXgN^}%en{Constructor} */
HASHTABLE_ERR HashTable_Constructor(C_HASHTABLE *self, int iTableSize, C_MEMHEAP *pMemHeap)
{
	T_HASHTABLE_NODE	**ppTable;
	int					i;

	/* m */
	if ( (ppTable = (T_HASHTABLE_NODE **)MemHeap_Alloc(pMemHeap, sizeof(T_HASHTABLE_NODE *) * iTableSize)) == NULL )
	{
		return HASHTABLE_ERR_NG;
	}

	/*  */
	for ( i = 0; i < iTableSize; i++ )
	{
		ppTable[i] = NULL;
	}

	/* lݒ */
	self->pMemHeap   = pMemHeap;
	self->ppTable    = ppTable;
	self->iTableSize = iTableSize;
	self->iDataNum   = 0;
	
	return HASHTABLE_ERR_OK;
}


/* end of file */
