/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  hashtable.h
 * @brief %jp{nbVe[u}%en{Hash table}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__hashtable_h__
#define __HOS__hashtable_h__


#include "library/container/memheap/memheap.h"


#define HASHTABLE_ERR_OK		0
#define HASHTABLE_ERR_NG		(-1)
#define HASHTABLE_POS_NULL		(0)

typedef int     HASHTABLE_ERR;


struct t_hashtable_iterator;
struct c_hashtable;


/** %jp{m[hi[p\}%en{node} */
typedef struct t_hashtable_node
{
	struct t_hashtable_node		*pNext;
	struct t_hashtable_iterator	*pIterator;
} T_HASHTABLE_NODE;


/** %jp{nbVpCe[^}%en{Iterator} */
typedef struct t_hashtable_iterator
{
	struct t_hashtable_node		*pNode;
	int							iIndex;
	
	struct t_hashtable_iterator	*pNext;
	struct t_hashtable_iterator	*pPrev;
} T_HASHTABLE_ITERATOR;



/** %jp{nbVe[uNX}%en{Hash table class} */
typedef struct c_hashtable
{
	T_HASHTABLE_NODE	**ppTable;
	C_MEMHEAP			*pMemHeap;
	int					iTableSize;
	int					iDataNum;
} C_HASHTABLE;


#ifdef __cplusplus
extern "C" {
#endif

/* ^폜 */
C_HASHTABLE          *HashTable_Create(int iTableSize);																	/**< %jp{}%en{Create} */
C_HASHTABLE          *HashTable_CreateEx(int iTableSize, C_MEMHEAP *pMemHeap);											/**< %jp{}%en{Create} */
void                  HashTable_Delete(C_HASHTABLE *self);																/**< %jp{폜}%en{Delete} */
HASHTABLE_ERR         HashTable_Constructor(C_HASHTABLE *self, int iTableSize, C_MEMHEAP *pMemHeap);					/**< %jp{RXgN^}%en{Constructor} */
void                  HashTable_Destructor(C_HASHTABLE *self);															/**< %jp{fXgN^}%en{Destructor} */

/*  */
HASHTABLE_ERR         HashTable_Add(C_HASHTABLE *self, const char *pszKey, const void *pData, MEMSIZE Size);			/**< f[^̒ǉ */
HASHTABLE_ERR         HashTable_Set(C_HASHTABLE *self, const char *pszKey, const void *pData, MEMSIZE Size);			/**< f[^̐ݒ */
const void           *HashTable_Get(C_HASHTABLE *self, const char *pszKey);												/**< f[^̎Q */
HASHTABLE_ERR         HashTable_Remove(C_HASHTABLE *self, const char *pszKey);											/**< f[^̍폜 */
void                  HashTable_RemoveAll(C_HASHTABLE *self);															/**< f[^̑S폜 */

/* Ce[^ */
T_HASHTABLE_ITERATOR *HashTable_FindOpen(C_HASHTABLE *self);															/**< Ce[^̐ */
void                 HashTable_FindClose(C_HASHTABLE *self, T_HASHTABLE_ITERATOR *pIterator);							/**< Ce[^̍폜 */
const void           *Hashtable_FindNext(C_HASHTABLE *self, T_HASHTABLE_ITERATOR *pIterator, const char **ppszKey);		/**< 擾 */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__hashtable_h__ */


/* end of file */
