/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fixmemheap_local.h
 * @brief %jp{ŒTCYq[vNX}%en{fixed size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef __HOS__fixmemheap_local_h__
#define __HOS__fixmemheap_local_h__


#include "library/container/memheap/memheap_local.h"



/** %jp{FixMemHeapNX}%en{FixMemHeap class} */
typedef struct c_fixmemheap
{
	C_MEMHEAP			MemHeap;		/* p */
	
	void				*pMemBase;		/**< %jp{擪ubÑAhX} */
	void				**ppFree;		/**< %jp{󂫃ubNAhX} */

	MEMSIZE				BlkSize;		/**< %jp{ubNTCY} */
	MEMSIZE				BlkNum;			/**< %jp{ubN} */
} C_FIXMEMHEAP;


#ifdef __cplusplus
extern "C" {
#endif

void	FixMemHeap_Constructor(C_FIXMEMHEAP *self, void *pMemBase, MEMSIZE BlkSize,  MEMSIZE BlkNum);
#define FixMemHeap_Destructor(self)			do { } while (0)

void	*FixMemHeap_Alloc(void *pMemHeap, MEMSIZE Size);					/**< ̊蓖 */
void	*FixMemHeap_ReAlloc(void *pMemHeap, void *pMem, MEMSIZE Size);		/**< ̍Ċ蓖 */
void	FixMemHeap_Free(void *pMemHeap, void *pMem);						/**< ̊J */
MEMSIZE	FixMemHeap_GetSize(void *pMemHeap, void *pMem);						/**< ̃TCY擾 */
MEMSIZE	FixMemHeap_GetAlign(void *pMemHeap);								/**< ACg̎擾 */
MEMSIZE	FixMemHeap_AlignSize(void *pMemHeap, MEMSIZE Size);					/**< TCYACgPʂɊg */
int     FixMemHeap_IsMember(void *pMemHeap, void *pMem);					/**< q[vɑĂ邩`FbN */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__fixmemheap_local_h__ */


/* end of file */
