/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fixmemheap_alloc.c
 * @brief %jp{ŒTCYq[vNX}%en{fixed size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "fixmemheap_local.h"



/** %jp{MemHeapNX z֐e[u}%en{MemHeap class virtual function table} */
const static T_MEMHEAP_METHODS FixMemHeap_Methods =
	{
		FixMemHeap_Alloc,			/**< ̊蓖 */
		FixMemHeap_ReAlloc,			/**< ̍Ċ蓖 */
		FixMemHeap_Free,			/**< ̊J */
		FixMemHeap_GetSize,			/**< ̃TCY擾 */
		FixMemHeap_GetAlign,		/**< ACg̎擾 */
		FixMemHeap_AlignSize,		/**< TCYACgPʂɊg */
		FixMemHeap_IsMember,		/**< q[vɑĂ邩`FbN */
	};



/** %jp{RXgN^} */
void FixMemHeap_Constructor(C_FIXMEMHEAP *self, void *pMemBase, MEMSIZE BlkSize,  MEMSIZE BlkNum)
{
	void	**ppBlk;
	void	**ppBlkNext;
	MEMSIZE i;

	/* %jp{eNXRXgN^} */
	MemHeap_Constructor(&self->MemHeap, &FixMemHeap_Methods);
	
	/* oϐݒ */
	self->pMemBase  = pMemBase;				/**< %jp{擪ubÑAhX} */
	self->BlkSize   = BlkSize;				/**< %jp{ubNTCY} */
	self->BlkNum    = BlkNum;				/**< %jp{ubN} */
	
	/*  */
	ppBlk = (void **)self->pMemBase;
	for ( i = 0; i < BlkNum - 1; i++ )
	{
		ppBlkNext = (void **)((char *)ppBlk + BlkSize);
		*ppBlk    = (void *)ppBlkNext;
		ppBlk     = ppBlkNext;
	}
	*ppBlk = NULL;
	
	self->ppFree = (void **)self->pMemBase;
}


/* end of file */
