/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  automemheap_alloc.c
 * @brief %jp{q[vNX}%en{auto size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "automemheap_local.h"



/** %jp{MemHeapNX z֐e[u}%en{MemHeap class virtual function table} */
const static T_MEMHEAP_METHODS AutoMemHeap_Methods =
	{
		AutoMemHeap_Alloc,			/**< ̊蓖 */
		AutoMemHeap_ReAlloc,		/**< ̍Ċ蓖 */
		AutoMemHeap_Free,			/**< ̊J */
		AutoMemHeap_GetSize,		/**< ̃TCY擾 */
		AutoMemHeap_GetAlign,		/**< ACg̎擾 */
		AutoMemHeap_AlignSize,		/**< TCYACgPʂɊg */
	};



/** %jp{RXgN^} */
void AutoMemHeap_Constructor(C_AUTOMEMHEAP *self, C_MEMHEAP *pMemHeap)
{
	/* %jp{eNXRXgN^} */
	MemHeap_Constructor(&self->MemHeap, &AutoMemHeap_Methods);
	
	/* oϐݒ */
	self->pValList = NULL;
	self->pFixList = NULL;
	self->pMemList = NULL;
	
	self->ValSize = 4096;
	self->FixSize = MemHeap_AlignSize(&self->MemHeap, 16);
	self->FixNum  = 4096 / self->FixSize;
	self->iValMax = 16;
	self->iFixMax = 16;
}


/* end of file */
