/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  assoc.c
 * @brief %jp{AzzNX}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */

#include <stdio.h>
#include <string.h>
#include "hosaplfw.h"
#include "assoc_local.h"



/* f[^̎Q */
const void *Assoc_Get(C_ASSOC *self, const char *pszKey)
{
	T_ASSOC_NODE	*pNode;
	char			*pszNodeKey;
	int				iKeyLen;
	
	if ( self->pRoot == NULL )
	{
		return NULL;
	}
	
	/* T */
	pNode = Assoc_GetNode(self, self->pRoot, pszKey);
	if ( pNode == NULL )
	{
		return NULL;
	}
	
	/* lo */
	pszNodeKey   = (char *)pNode + sizeof(T_ASSOC_NODE);
	iKeyLen = MemHeap_AlignSize(self->pMemHeap, strlen(pszKey) + 1);
	return (void *)(pszNodeKey + iKeyLen);
}



/* end of file */
