/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  arraybuf.h
 * @brief %jp{Xgobt@NX}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__array_h__
#define __HOS__array_h__


#include "library/container/memheap/memheap.h"

/* G[R[h */
#define ARRAY_ERR_OK			0
#define ARRAY_ERR_NG			(-1)

/* TCYg̒P */
#define ARRAY_SIZE_UNIT			16

typedef int		ARRAY_ERR;
typedef int		ARRAY_INDEX;


/* Xg[obt@NX */
typedef struct c_array
{
	C_MEMHEAP	*pMemHeap;	/* p郁I/F */
	void		**ppArray;	/* f[^z */
	ARRAY_INDEX	ArraySize;	/* zTCY */
	ARRAY_INDEX	Size;		/* zvf̃TCY */
} C_ARRAY;


#ifdef __cplusplus
extern "C" {
#endif

/* ^폜 */
void        Array_Create(C_ARRAY *self);													/* zNX̐ */
void        Array_CreateEx(C_ARRAY *self, C_MEMHEAP *pMemHeap);								/* zNX̐ */
void        Array_Delete(C_ARRAY *self);													/* zNX̍폜 */

/*  */
ARRAY_INDEX Array_GetSize(C_ARRAY *self);													/* zTCY̎擾 */
ARRAY_ERR   Array_SetSize(C_ARRAY *self, ARRAY_INDEX Size);									/* zTCY̐ݒ */
void        Array_Clear(C_ARRAY *self);														/* z̃NA */
ARRAY_ERR   Array_Add(C_ARRAY *self, const void *pData, long lSize);						/* f[^̒ǉ */
ARRAY_ERR   Array_SetAt(C_ARRAY *self, ARRAY_INDEX Index, const void *pData, long lSize);	/* f[^̐ݒ */
void       *Array_GetAt(C_ARRAY *self, ARRAY_INDEX Index);									/* f[^̑} */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__array_h__ */


/* end of file */
