/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  stringformat.c
 * @brief %jp{tH[}bgCu}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "stringformat_local.h"



/* 16io */
int StringFormat_Hexadecimal(int (*pfncPut)(int c, void *Param), void *Param, unsigned long ulNum, int iWidth, int iPadChar, int iFlag)
{
	unsigned long	ulTmp;
	int				iLen = 0;
	int				iSize = 0;
	int				iPadSize;
	
	
	/* Œ\ɕKvȃTCYZo */
	ulTmp = ulNum;
	do
	{
		iSize++;
		ulTmp >>= 4;
	} while ( ulTmp != 0 );
	
	/* peBOTCY */
	iPadSize = iWidth - iSize;
	
	/* lΐɃpfBO */
	if ( iFlag != '-' )
	{
		while ( iPadSize > 0 )
		{
			if ( pfncPut(iPadChar, Param) <= 0 )
			{
				return iLen;
			}
			iLen++;

			iPadSize--;
		}
	}
	
	/* ʌ珇ɏo */
	iSize = (iSize - 1) * 4;
	do
	{
		if ( StringFormat_Nibble(pfncPut, Param, (unsigned char)(ulNum >> iSize)) <= 0 )
		{
			return iLen;
		}
		iLen++;
		
		iSize -= 4;
	} while ( iSize >= 0 );
	
	
	/* lȂpfBO */
	if ( iFlag == '-' )
	{
		while ( iPadSize > 0 )
		{
			if ( pfncPut(' ', Param) <= 0 )
			{
				return iLen;
			}
			iLen++;

			iPadSize--;
		}
	}
	
	return iLen;
}


/* end of file */
