/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.c
 * @brief %jp{FAT{[pfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "fatvol_local.h"


/** %jp{} */
FILE_SIZE FatVol_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size)
{
	C_FATVOL			*self;
	C_FATFILE			*pFile;

	FILE_SIZE			ReqSize;
	const unsigned char	*pubData;
	FATVOL_UINT			uiNextCluster;
	FATVOL_UINT			uiCluster;
	FATVOL_UINT			i;
	int                 iResizeFlag = 0;

	
	/* upper cast */
	self  = (C_FATVOL *)pDrvObj;
	pFile = (C_FATFILE *)pFileObj;

	/* LXg */
	pubData = (const unsigned char *)pData;

	/* TCY0Ȃ瑦 */
	if ( Size <= 0 )
	{
		return 0;
	}

	/* NeBJZNVɓ */
	SysMtx_Lock(self->hMtx);
	
	/* [h`FbN */
	if ( !(FileObj_GetMode(&pFile->FileObj) & FILE_OPEN_WRITE) || (FileObj_GetMode(&pFile->FileObj) & FILE_OPEN_DIR) )
	{
		SysMtx_Unlock(self->hMtx);
		return 0;
	}
		
	/* ݗvʕۑ */
	ReqSize = Size;
	
	/* t@C|C^ʒũNX^ */
	uiCluster = pFile->uiStartCluster;
	for ( i = 0; pFile->FilePos >= (FILE_POS)((i + 1) * self->BytesPerCluster); i++ )
	{
		/* ̃NX^T */
		uiNextCluster = FatVol_GetNextCluster(self, uiCluster);
		if ( uiNextCluster == FATVOL_CLUSTER_ENDMARKER )
		{
			/* NX^΍ */
			uiNextCluster = FatVol_AllocCluster(self);
			if ( uiNextCluster == FATVOL_CLUSTER_ENDMARKER )
			{
				return 0;	/* fBXNt */
			}
			FatVol_SetNextCluster(self, uiCluster, uiNextCluster);
		}
		uiCluster = uiNextCluster;
	}
	
	
	/* o */
	while ( Size > 0 )
	{
		FILE_POS			WriteStart;
		FILE_SIZE			WriteSize;
		T_FATVOL_CLUSTERBUF	*pClusterBuf;
				
		/* ]ʒuvZ */
		WriteStart = (pFile->FilePos & (self->BytesPerCluster - 1));
		WriteSize  = (FILE_SIZE)(self->BytesPerCluster - WriteStart);
		if ( WriteSize > Size )
		{
			WriteSize = Size;
		}

		/* obt@擾 */
		if ( WriteStart == 0 && pFile->FilePos == pFile->FileSize )
		{
			pClusterBuf = FatVol_GetClusterBuf(self, uiCluster, 0);		/* SVK̏ꍇ */
		}
		else
		{
			pClusterBuf = FatVol_GetClusterBuf(self, uiCluster, 1);		/* XV̏ꍇ */
		}
		if ( pClusterBuf == NULL )
		{
			break;
		}

		/* ] */
		memcpy(&pClusterBuf->pubBuf[WriteStart], pubData, WriteSize);
	
		/* obt@J */
		FatVol_RelClusterBuf(self, pClusterBuf, 1);
		
		
		/* TCYXV */
		pFile->FilePos += WriteSize;
		pubData        += WriteSize;
		Size           -= WriteSize;
		
		/* t@CTCYXV */
		if ( pFile->FileSize < pFile->FilePos )
		{
			pFile->FileSize = pFile->FilePos;
			iResizeFlag     = 1;
		}
		
		/* `FbN */
		if ( Size <= 0 )
		{
			break;
		}
		
		/* ̃NX^T */
		uiNextCluster = FatVol_GetNextCluster(self, uiCluster);
		if ( uiNextCluster == FATVOL_CLUSTER_ENDMARKER )
		{
			/* NX^΍ */
			uiNextCluster = FatVol_AllocCluster(self);
			if ( uiNextCluster == FATVOL_CLUSTER_ENDMARKER )
			{
				break;	/* fBXNt */
			}
			FatVol_SetNextCluster(self, uiCluster, uiNextCluster);
		}
		uiCluster = uiNextCluster;
		
		/* UbN */
		SysMtx_Unlock(self->hMtx);
		SysMtx_Lock(self->hMtx);		
	}
	
	/* fBNge[ũTCYXV */
	if ( iResizeFlag &&	!(FileObj_GetMode(&pFile->FileObj) & FILE_OPEN_DIR) )
	{
		FatVol_SyncFileSize(self, pFile);
	}

	/* NeBJZNVo */
	SysMtx_Unlock(self->hMtx);
	
	return ReqSize - Size;	
}


/* end of file */
