/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.c
 * @brief %jp{FAT{[pfoCXhCo}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "hosaplfw.h"
#include "fatvol_local.h"


/* t@CI[v */
HANDLE FatVol_Open(C_DRVOBJ *pDrvObj, const char *pszPath, int iMode)
{
	C_FATVOL 			*self;
	HANDLE 				hFile;
	FATVOL_UINT			uiDirStartCluster;	
	FATVOL_UINT			uiDirCluster;	
	FATVOL_UINT			uiDirEntryPos;
	char   				szName[8+3];
	int    				iNameLen;
	FATVOL_UINT			uiFileCluster;
	unsigned char		ubFileAttr;
	FILE_POS			FileSize;
	T_FATVOL_CLUSTERBUF *pClusterBuf;
	unsigned char		*pubBuf;
	int					iEntryHit;
	int    				i, j;
	
	
	/* upper cast */
	self = (C_FATVOL *)pDrvObj;
	
	
	/* NeBJZNVɓ */
	SysMtx_Lock(self->hMtx);
	
	
	/* [gfBNgݒ */
	uiDirStartCluster = FATVOL_CLUSTER_ENDMARKER;
	uiDirCluster      = FATVOL_CLUSTER_ENDMARKER;
	uiDirEntryPos     = 0;
	uiFileCluster     = self->RootDirCluster;
	ubFileAttr        = 0x10;
	FileSize          = 0;
	
	/* pXT */
	for ( ; ; )
	{
		/* ؂ǂݔ΂ */
		while ( pszPath[0] == '/' )
		{
			pszPath++;
		}

		/* O̕T */
		for ( i = 0; pszPath[i] != '\0'; i++ )
		{
			/* pX؂Ȃ甲 */
			if ( pszPath[i] == '/' )
			{
				break;
			}
		}
		iNameLen = i;

		/* fBNggwꍇ */
		if ( iNameLen == 0 )
		{
			iEntryHit = 1;
			break;
		}
		
		/* fBNgGg쐬 */
		for ( i = 0, j = 0; i < iNameLen && j < 8; i++, j++ )
		{
			if ( pszPath[i] == '.' )
			{
				break;
			}
			szName[j] = pszPath[i];
		}
		for ( ; j < 8; j++ )
		{
			szName[j] = 0x20;
		}
		if ( pszPath[i] != '.' && i < iNameLen )	/* t@C */
		{
			SysMtx_Unlock(self->hMtx);
			return HANDLE_NULL;
		}
		
		/* gq */
		if ( pszPath[i] == '.' )
		{
			i++;
		}
		for ( j = 0; i < iNameLen && j < 3; i++, j++ )
		{
			szName[8+j] = pszPath[i];
		}
		for ( ; j < 3; j++ )
		{
			szName[8+j] = 0x20;
		}
		if ( i < iNameLen )		/* gq */
		{
			SysMtx_Unlock(self->hMtx);
			return HANDLE_NULL;
		}
		

		/* |C^i߂ */
		pszPath += iNameLen;

		
		/* ϊ */
		for ( i = 0; i < 8+3; i++ )
		{
			/* 啶 */
			if ( szName[i] >= 'a' && szName[i] <= 'z')
			{
				szName[i] -= ('a' - 'A');
			}
		}
		if ( szName[0] == 0xe5 )
		{
			szName[0] = 0x05;
		} 
				
		
		
		/* fBNgJ */
		uiDirStartCluster = uiFileCluster;
		uiDirCluster      = uiDirStartCluster;
		uiDirEntryPos     = 0;
		if ( (pClusterBuf = FatVol_GetClusterBuf(self, uiDirCluster, 1)) == NULL )
		{
			SysMtx_Unlock(self->hMtx);
			return HANDLE_NULL;
		}
		
		/* fBNgGg */
		iEntryHit = 0;
		for ( ; ; )
		{
			/* fBNgGgʒu */
			pubBuf = &pClusterBuf->pubBuf[uiDirEntryPos];
			
			/* 0Ȃł؂ */
			if ( pubBuf[0] == 0x00 )
			{
				break;
			}
			
			/* Or */
			if ( memcmp(pubBuf, szName, 8+3) == 0 )
			{
				/* JnNX^擾 */
				uiFileCluster = pubBuf[26] + (pubBuf[27] << 8);
				if ( self->iFatType == FATVOL_TYPE_FAT32 )
				{
					uiFileCluster += (pubBuf[20] << 16) + (pubBuf[21] << 24);
				}
				
				/* 擾 */ 
				ubFileAttr = pubBuf[11];
				
				/* TCY擾 */
				FileSize = pubBuf[28] + (pubBuf[29] << 8) + (pubBuf[30] << 16) + (pubBuf[31] << 24);
				
				iEntryHit = 1;
				break;
			}
			
			/* V[N */
			uiDirEntryPos += 32;
			if ( uiDirEntryPos >= self->BytesPerCluster )
			{
				FatVol_RelClusterBuf(self, pClusterBuf, 0);
				uiDirCluster = FatVol_GetNextCluster(self, uiDirCluster);
				if ( uiDirCluster == FATVOL_CLUSTER_ENDMARKER
					|| (pClusterBuf = FatVol_GetClusterBuf(self, uiDirCluster, 1)) == NULL )
				{
					SysMtx_Unlock(self->hMtx);
					return HANDLE_NULL;
				}
				uiDirEntryPos = 0;
			}
		}
		
		/* fBNg */
		FatVol_RelClusterBuf(self, pClusterBuf, 0);
		
		
		/* ȏJTufBNgȂΔ */
		if ( !(iEntryHit && (ubFileAttr & 0x10)) )
		{
			break;
		}
	}
	
	
	/* pXׂĒTłĂȂNG */
	if ( *pszPath != '\0' )
	{
		SysMtx_Unlock(self->hMtx);
		return HANDLE_NULL;
	}
	
	
	/* fBNgɑ݂Ȃꍇ */
	if ( !iEntryHit )
	{
		/* VK쐬֎~Ȃ΃G[ */
		if ( iMode & FILE_OPEN_EXIST )
		{
			SysMtx_Unlock(self->hMtx);
			return HANDLE_NULL;			
		}
				
		/* fBNgJ */
		uiDirCluster  = uiDirStartCluster;
		uiDirEntryPos = 0;
		if ( (pClusterBuf = FatVol_GetClusterBuf(self, uiDirCluster, 1)) == NULL )
		{
			SysMtx_Unlock(self->hMtx);
			return HANDLE_NULL;
		}
		
		/* 󂫒T */
		for ( ; ; )
		{
			/* fBNgGgʒu */
			pubBuf = &pClusterBuf->pubBuf[uiDirEntryPos];
			
			/* 󂫔 */
			if ( pubBuf[0] == 0xe5 || pubBuf[0] == 0x00 )
			{
				break;
			}
			
			/* V[N */
			uiDirEntryPos += 32;
			if ( uiDirEntryPos >= self->BytesPerCluster )	/* NX^zȂ */
			{
				FatVol_RelClusterBuf(self, pClusterBuf, 0);
				uiDirCluster = FatVol_GetNextCluster(self, uiDirCluster);
				if ( uiDirCluster == FATVOL_CLUSTER_ENDMARKER )
				{
					/* FAT32ȊÕ[gfBNgȂgs\ */
					if ( self->iFatType != FATVOL_TYPE_FAT32 && uiDirCluster >= 0x0f000000 )
					{
						SysMtx_Unlock(self->hMtx);
						return HANDLE_NULL;						
					}
					if ( (uiFileCluster = FatVol_AllocCluster(self)) == FATVOL_CLUSTER_ENDMARKER )
					{
						SysMtx_Unlock(self->hMtx);
						return HANDLE_NULL;						
					}
					FatVol_SetNextCluster(self, uiDirCluster, uiFileCluster);
					uiDirCluster = uiFileCluster;
				}
				if ( (pClusterBuf = FatVol_GetClusterBuf(self, uiDirCluster, 1)) == NULL )
				{
					SysMtx_Unlock(self->hMtx);
					return HANDLE_NULL;
				}
				uiDirEntryPos = 0;
			}
		}
		
		/* VKNX^쐬 */
		if ( (uiFileCluster = FatVol_AllocCluster(self)) == FATVOL_CLUSTER_ENDMARKER )
		{
			FatVol_RelClusterBuf(self, pClusterBuf, 0);
			SysMtx_Unlock(self->hMtx);
			return HANDLE_NULL;			
		}
		FatVol_SetNextCluster(self, uiFileCluster, FATVOL_CLUSTER_ENDMARKER);
		
		MemUtil_MemSetB(&pubBuf[0], 0, 32);						/*  */
		MemUtil_MemCopyB(&pubBuf[0], szName, 8+3);				/* t@C */
		pubBuf[11] = (iMode & FILE_OPEN_DIR) ? 0x10 : 0x20;		/*  */
		pubBuf[26] = ((uiFileCluster >>  0) & 0xff);			/* JnNX^ */
		pubBuf[27] = ((uiFileCluster >>  8) & 0xff);
		pubBuf[20] = ((uiFileCluster >> 16) & 0xff);
		pubBuf[21] = ((uiFileCluster >> 24) & 0xff);
		FileSize   = 0;
		ubFileAttr = pubBuf[11];
		
		/* fBNg */
		FatVol_RelClusterBuf(self, pClusterBuf, 1);
	}
	else
	{
		/* ݂ꍇ */
		if ( iMode & FILE_OPEN_CREATE )
		{
			FatVol_FreeCluster(self, uiFileCluster);
			FatVol_SetNextCluster(self, uiFileCluster, FATVOL_CLUSTER_ENDMARKER);
			FileSize = 0;
		}
	}
	
	/* [h`FbN */
	if ( ((ubFileAttr & 0x10) && !(iMode & FILE_OPEN_DIR))
		|| (!(ubFileAttr & 0x10) && (iMode & FILE_OPEN_DIR)) )
	{
		SysMtx_Unlock(self->hMtx);
		return HANDLE_NULL;		
	}
	
	/* t@CfBXNv^쐬 */
	hFile = FatFile_Create(self, uiFileCluster, uiDirCluster, uiDirEntryPos, FileSize, iMode);
	if ( hFile != HANDLE_NULL )
	{
		self->iOpenCount++;
	}
	
	/* NeBJZNVo */
	SysMtx_Unlock(self->hMtx);
	
	return hFile;
}


/* end of file */
