/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.h
 * @brief %jp{FAT{[pfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__fatvol_local_h__
#define __HOS__fatvol_local_h__


#include "fatvol.h"
#include "system/file/volumeobj_local.h"


/* ŏINX^}[J[ */
#define FATVOL_CLUSTER_FREE				0x00000000
#define FATVOL_CLUSTER_ENDMARKER		0x0fffffff


/* t@CVXẽ^Cv */
#define FATVOL_TYPE_UNKNOWN				0
#define FATVOL_TYPE_FAT12				1
#define FATVOL_TYPE_FAT16				2
#define FATVOL_TYPE_FAT32				3


/* NX^obt@ */
typedef struct t_fatvol_clusterbuf
{
	FATVOL_UINT		uiClusterNum;
	int				iDirty;
	unsigned char	*pubBuf;
} T_FATVOL_CLUSTERBUF;


/* NX^obt@ */
typedef struct c_fatvol
{
	C_VOLUMEOBJ			VolumeObj;					/* {[IuWFNgp */

	HANDLE				hBlockFile;					/**< ubNfoCXhCõnh */
	
	SYSMTX_HANDLE		hMtx;						/**< bNp~[ebNX */
	
	int					iShutdown;					/**< Vbg_EtO */
	int					iOpenCount;					/**< I[vJE^ */
	
	int					iFatType;					/**< FAT̃^Cv */
	FILE_POS			Offset;						/**< fBXÑItZbg */
	FILE_POS			DriveSize;					/**< hCȗTCY */
	FATVOL_UINT			BytesPerSector;				/**< ZN^TCY */
	FATVOL_UINT			SectorsPerCluster;			/**< NX^̃ZN^ */
	FATVOL_UINT			BytesPerCluster;			/**< NX^TCY */
	FATVOL_UINT			FatStartSector;				/**< FAT̊JnZN^ԍ */
	FATVOL_UINT			SectorNum;					/**< ZN^ */
	FATVOL_UINT			SectorPerFat;				/**< FAT̃ZN^ */
	FATVOL_UINT			FatNum;						/**< FAŤ */
	FATVOL_UINT			RootDirEntryNum;			/**< [gfBNg̃Gg */
	FATVOL_UINT			RootDirSector;				/**< [gfBNg̃ZN^ */
	FATVOL_UINT			Cluster0Sector;				/**< NX^0̃ZN^ԍ */
	FATVOL_UINT			ClusterNum;					/**< NX^ */
	FATVOL_UINT			RootDirCluster;				/**< [gfBNg̃NX^ԍ */
	
	unsigned char		*pubFatBuf;					/**< FAT̃obt@O */
	unsigned char		*pubFatDirty;				/**< FAT̍XVtO */
	
	struct t_fatvol_clusterbuf	*pClusterBuf;
	int							iClusterBufNum;
} C_FATVOL;


#include "fatfile.h"


struct c_fatfile;

#ifdef __cplusplus
extern "C" {
#endif

FATVOL_ERR          FatVol_Constructor(C_FATVOL *self, const T_VOLUMEOBJ_METHODS *pMethods, const char *pszPath);
void                FatVol_Destructor(C_FATVOL *self);

HANDLE              FatVol_Open(C_DRVOBJ *pDrvObj, const char *pszPath, int iMode);
void                FatVol_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);
FILE_ERR            FatVol_IoControl(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, int iFunc, void *pInBuf, FILE_SIZE InSize, const void *pOutBuf, FILE_SIZE OutSize);
FILE_POS            FatVol_Seek(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, FILE_POS Offset, int iOrign);
FILE_SIZE           FatVol_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size);
FILE_SIZE           FatVol_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size);
FILE_ERR            FatVol_Flush(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);

FILE_ERR            FatVol_Shutdown(C_VOLUMEOBJ *pVolObj);														/**< Vbg_E */
FILE_ERR            FatVol_MakeDir(C_VOLUMEOBJ *pVolObj, const char *pszPath);									/**< TufBNg쐬 */
FILE_ERR            FatVol_Remove(C_VOLUMEOBJ *pVolObj, const char *pszPath);									/**< t@C폜 */

void                FatVol_SyncFileSize(C_FATVOL *self, struct c_fatfile *pFile);								/**< TCY */

int                 FatVol_ClusterWrite(C_FATVOL *self, FATVOL_UINT uiCluster, const void *pBuf);				/**< NX^ */
int                 FatVol_ClusterRead(C_FATVOL *self, FATVOL_UINT uiCluster, void *pBuf);						/**< NX^ǂݍ */

T_FATVOL_CLUSTERBUF *FatVol_GetClusterBuf(C_FATVOL *self, FATVOL_UINT uiCluster, int iRead);
void                FatVol_RelClusterBuf(C_FATVOL *self, T_FATVOL_CLUSTERBUF *pClusterBuf, int iDirty);							
void                FatVol_FlushClusterBuf(C_FATVOL *self);

FATVOL_UINT         FatVol_AllocCluster(C_FATVOL *self);
void                FatVol_FreeCluster(C_FATVOL *self, FATVOL_UINT uiCluster);
FATVOL_UINT         FatVol_GetNextCluster(C_FATVOL *self, FATVOL_UINT uiCluster);
void                FatVol_SetNextCluster(C_FATVOL *self, FATVOL_UINT uiCluster, FATVOL_UINT uiNextCluster);


void        FatVol_FlushFat(C_FATVOL *self);


#ifdef __cplusplus
}
#endif


#endif	/*  __HOS__fatvol_local_h__ */


/* end of file */
