/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.c
 * @brief %jp{FAT{[pfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "fatvol_local.h"


FILE_ERR FatVol_Flush(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj)
{
	C_FATVOL	*self;
	
	/* upper cast */
	self  = (C_FATVOL *)pDrvObj;

	/* NeBJZNVɓ */
	SysMtx_Lock(self->hMtx);
	
	/* FAT̏o */
	FatVol_FlushFat(self);
	
	/* obt@̃tbV */
	FatVol_FlushClusterBuf(self);
	
	
	/* NeBJZNVo */
	SysMtx_Unlock(self->hMtx);

	return FILE_ERR_OK;
}


/* end of file */
