/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol_delete.c
 * @brief %jp{FAT{[pfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "fatvol_local.h"


/** fXgN^ */
void FatVol_Destructor(C_FATVOL *self)
{
	int	i;
	
	/* foCXN[Y */
	File_Close(self->hBlockFile);
	
	/* NX^obt@J */
	for ( i = 0; i < self->iClusterBufNum; i++ )
	{
		SysIo_FreeIoMem(self->pClusterBuf[i].pubBuf);
	}
	SysMem_Free(self->pClusterBuf[i].pubBuf);
	
	/* ~[ebNX폜 */
	SysMtx_Delete(self->hMtx);
	
	/* eNXfRXgN^Ăяo */
	VolumeObj_Delete(&self->VolumeObj);
}


/* end of file */
