/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.h
 * @brief %jp{FAT{[pfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__fatfile_h__
#define __HOS__fatfile_h__


#include "fatvol_local.h"
#include "system/file/fileobj_local.h"


/* t@CfBXNv^ */
typedef struct c_fatfile
{
	C_FILEOBJ	FileObj;			/* {[IuWFNgp */
	
	FATVOL_UINT	uiStartCluster;		/* t@C̐擪NX^ */
	
	FATVOL_UINT	uiDirCluster;		/* fBNg̃NX^ʒu */
	FATVOL_UINT	uiDirEntryPos;		/* fBNg̃Ggʒu */
	
	FILE_POS	FilePos;			/* t@C|C^ */
	FILE_POS	FileSize;			/* t@CTCY */
} C_FATFILE;



#ifdef __cplusplus
extern "C" {
#endif

HANDLE FatFile_Create(C_FATVOL *pFatVol, FATVOL_UINT uiStartCluster, FATVOL_UINT uiDirCluster, FATVOL_UINT uiDirEntryPos, FILE_POS FileSize, int iMode);
void   FatFile_Delete(HANDLE hFile);

#ifdef __cplusplus
}
#endif


#endif	/*  __HOS__fatvol_local_h__ */


/* end of file */
