/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  ipether.h
 * @brief %jp{EtherIPvgR(܂MACwߕ)}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "ipether_local.h"


static void IpEther_RecvArp(C_IPETHER *self, unsigned char *pubBuf, int iSize);
static void IpEther_RecvIp(C_IPETHER *self, unsigned char *pubBuf, int iSize);


/* MvZX */
void IpEther_Recv(void)
{
	C_IPETHER		*self;
	int				iRecvTail;
	unsigned char	*pubRecvBuf;
	unsigned short	uhProtocolType;
	int				iSize;
	
	/* upper cast */
	self  = (C_IPETHER *)SysPrc_GetParam(SysPrc_GetCurrentHandle());
	
	for ( ; ; )
	{
		/* Mʒuݒ */
		SysMtx_Lock(self->hMtxRecv);
		iRecvTail = self->iRecvHead + self->iRecvNum;
		if ( iRecvTail >= IPETHER_RECVBUS_SIZE )
		{
			iRecvTail = 0;
		}
		SysMtx_Unlock(self->hMtxRecv);
		pubRecvBuf = self->ubRecvBuf[iRecvTail];
		
		/* M */
		if ( (iSize = File_Read(self->hEther, pubRecvBuf, IPETHER_MAXPACKET_SIZE)) < 60 )
		{
			continue;
		}
		
		/* vgR^Cv */
		uhProtocolType = (pubRecvBuf[12] * 256) + pubRecvBuf[13];
		switch ( uhProtocolType )
		{
		case 0x0800:	/* IP */
			IpEther_RecvIp(self, pubRecvBuf, iSize);
			break;
			
		case 0x0806:	/* ARP */
			IpEther_RecvArp(self, pubRecvBuf, iSize);
			break;
			
		}
	}
}


/* IPM */
void IpEther_RecvIp(C_IPETHER *self, unsigned char *pubBuf, int iSize)
{
	/* Oobt@i߂ */
	SysMtx_Lock(self->hMtxRecv);
	if ( self->iRecvNum < IPETHER_RECVBUS_SIZE - 1 )
	{
		iSize -= 14;
		pubBuf[0] = iSize / 256;
		pubBuf[1] = iSize % 256;
		self->iRecvNum++;
	}
	SysMtx_Unlock(self->hMtxRecv);
	
	SysEvt_Set(self->hEvtRecv);
}


/* ARP */
void IpEther_RecvArp(C_IPETHER *self, unsigned char *pubBuf, int iSize)
{
	int i;

	if ( pubBuf[14] == 0x00 && pubBuf[15] == 0x01		/* n[hEFA^Cv(Ether) */
		&& pubBuf[16] == 0x08 && pubBuf[17] == 0x00		/* vgR^Cv(IP) */
		&& pubBuf[18] == 0x06							/* n[hEFAAhX */
		&& pubBuf[19] == 0x04							/* vgRAhX */
		&& pubBuf[38] == self->ubMyIpAddr[0]
		&& pubBuf[39] == self->ubMyIpAddr[1]
		&& pubBuf[40] == self->ubMyIpAddr[2]
		&& pubBuf[41] == self->ubMyIpAddr[3] )
	{
		if ( pubBuf[20] == 0x00 && pubBuf[21] == 0x01 )		/* Iy[V(ARPv) */
		{
			unsigned char	*pubSendBuf;
			
			/* ΋MACAhX̓o^ */
			IpEther_AddMacAddr(self, &pubBuf[22], &pubBuf[28]);
			
			/* NeBJZNVɓ */
			SysMtx_Lock(self->hMtxSend);

			/* ARPԂ */
			pubSendBuf = self->ubSendBuf;

			/* MACAhX */
			pubSendBuf[0]  = pubBuf[22];
			pubSendBuf[1]  = pubBuf[23];
			pubSendBuf[2]  = pubBuf[24];
			pubSendBuf[3]  = pubBuf[25];
			pubSendBuf[4]  = pubBuf[26];
			pubSendBuf[5]  = pubBuf[27];
			
			/* MACAhX */
			pubSendBuf[6]  = self->ubMyMacAddr[0];
			pubSendBuf[7]  = self->ubMyMacAddr[1];
			pubSendBuf[8]  = self->ubMyMacAddr[2];
			pubSendBuf[9]  = self->ubMyMacAddr[3];
			pubSendBuf[10] = self->ubMyMacAddr[4];
			pubSendBuf[11] = self->ubMyMacAddr[5];

			/* vgR^Cv (ARP) */
			pubSendBuf[12] = 0x08;
			pubSendBuf[13] = 0x06;
			
			/* n[hEFA^Cv(Ether) */
			pubSendBuf[14] = 0x00;
			pubSendBuf[15] = 0x01;
			
			/* vgR^Cv(IP) */
			pubSendBuf[16] = 0x08;
			pubSendBuf[17] = 0x00;
			
			/* n[hEFAAhX */
			pubSendBuf[18] = 0x06;
			
			/* vgRAhX */
			pubSendBuf[19] = 0x04;
			
			/* Iy[V(ARP) */
			pubSendBuf[20] = 0x00;
			pubSendBuf[21] = 0x02;
			
			/* Mn[hEFAAhX */
			pubSendBuf[22] = self->ubMyMacAddr[0];
			pubSendBuf[23] = self->ubMyMacAddr[1];
			pubSendBuf[24] = self->ubMyMacAddr[2];
			pubSendBuf[25] = self->ubMyMacAddr[3];
			pubSendBuf[26] = self->ubMyMacAddr[4];
			pubSendBuf[27] = self->ubMyMacAddr[5];

			/* MvgRAhX */
			pubSendBuf[28] = self->ubMyIpAddr[0];
			pubSendBuf[29] = self->ubMyIpAddr[1];
			pubSendBuf[30] = self->ubMyIpAddr[2];
			pubSendBuf[31] = self->ubMyIpAddr[3];
			
			/* ^[Qbgn[hEFAAhX */
			pubSendBuf[32] = pubBuf[22];
			pubSendBuf[33] = pubBuf[23];
			pubSendBuf[34] = pubBuf[24];
			pubSendBuf[35] = pubBuf[25];
			pubSendBuf[36] = pubBuf[26];
			pubSendBuf[37] = pubBuf[27];
			
			/* ^[QbgvgRAhX */
			pubSendBuf[38] = pubBuf[28];
			pubSendBuf[39] = pubBuf[29];
			pubSendBuf[40] = pubBuf[30];
			pubSendBuf[41] = pubBuf[31];
			
			/* pfBO */
			for ( i = 42; i < 60; i++ )
			{
				pubSendBuf[i] = 0x00;
			}
			
			/* M */
			File_Write(self->hEther, pubSendBuf, 60);

			/* NeBJZNVo */
			SysMtx_Unlock(self->hMtxSend);
		}
		else if ( pubBuf[20] == 0x00 && pubBuf[21] == 0x02 )	/* Iy[V(ARP) */
		{
			/* ΋MACAhX̓o^ */
			IpEther_AddMacAddr(self, &pubBuf[22], &pubBuf[28]);		
		}
	}
}


/* endof file */
