/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  ipether.h
 * @brief %jp{EtherIPvgR(܂MACwߕ)}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__ipether_h__
#define __HOS__ipether_h__


#include "system/sysapi/sysapi.h"
#include "system/file/syncdrv_local.h"


#define IPETHER_ARPTBL_SIZE			4
#define IPETHER_RECVBUS_SIZE		4
#define IPETHER_MAXPACKET_SIZE		2048


/* IP-Ether */
typedef struct t_ipether_inf
{
	unsigned char	ubIpAddr[4];			/* IPAhX */
	unsigned char	ubSubNetMask[4];		/* Tulbg}XN */
	unsigned char	ubGateWayIpAddr[4];		/* ftHgQ[gEFCAhX */
} T_IPETHER_INF;



/* ARPe[u */
typedef struct t_ipether_arptbl
{
	unsigned char	ubIpAddr[4];	/* IPAhX */
	unsigned char	ubMacAddr[6];	/* MACAhX */
} T_IPETHER_ARPTBL;



/* EtherhCo䕔 */
typedef struct c_ipether
{
	C_SYNCDRV			SyncDrv;				/* LN^^foCXhCop */

	HANDLE				hEther;					/* EtherhCo */
	
	int					iOpenCount;				/* I[vJE^ */

	SYSPRC_HANDLE		hPrcRecv;				/* MvZX */
	SYSMTX_HANDLE		hMtxSend;				/* r~[ebNX */
	SYSMTX_HANDLE		hMtxRecv;				/* r~[ebNX */
	SYSMTX_HANDLE		hMtxArp;				/* r~[ebNX */

	SYSEVT_HANDLE		hEvtRecv;				/*  */
	SYSEVT_HANDLE		hEvtArp;				/*  */

	unsigned char		ubMyIpAddr[4];			/* IPAhX */
	unsigned char		ubMyMacAddr[6];			/* MACAhX */
	
	unsigned char		ubSubNetMask[4];		/* Tulbg}XN */
	unsigned char		ubGateWayIpAddr[4];		/* Q[gEFCIPAhX */
	
	T_IPETHER_ARPTBL	ArpTbl[IPETHER_ARPTBL_SIZE];
	
	int					iRecvHead;				/* MpPbg擪ʒu */
	int					iRecvNum;				/* MpPbg */

	unsigned char		ubSendBuf[IPETHER_MAXPACKET_SIZE];
	unsigned char		ubRecvBuf[IPETHER_RECVBUS_SIZE][IPETHER_MAXPACKET_SIZE];
} C_IPETHER;


#ifdef __cplusplus
extern "C" {
#endif

HANDLE IpEther_Create(const char *pszEther, const T_IPETHER_INF *pInf);		/**<  */
void   IpEther_Delete(HANDLE hDriver);										/**< 폜 */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__ipether_h__ */



/* endof file */
