/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  winsockdrv.h
 * @brief %jp{WinSockŃVA[hCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "winsockdrv_local.h"



DWORD WINAPI WinSockDrv_Recv(LPVOID Param)
{
	C_WINSOCKDRV		*self;
	WSADATA				wsaData;
	struct sockaddr_in	addr;
	struct sockaddr_in	client;
	int					len;
	unsigned char		ubBuf[128];
	int					iSize;

	self = (C_WINSOCKDRV *)Param;
	
	/* socket  */
	WSAStartup(MAKEWORD(2,0), &wsaData);
	self->sock0 = socket(AF_INET, SOCK_STREAM, 0);
	addr.sin_family = AF_INET;
	addr.sin_port = htons((u_short)self->iPortNum);
	addr.sin_addr.S_un.S_addr = INADDR_ANY;
	bind(self->sock0, (struct sockaddr *)&addr, sizeof(addr));
	listen(self->sock0, 5);

	for ( ; ; )
	{
		/* ڑ҂ */
		len = sizeof(client);
		self->sock = accept(self->sock0, (struct sockaddr *)&client, &len);
		if (self->sock == INVALID_SOCKET )
		{
			break;
		}
		
		/* MXbhJnw */
		self->iConnection = TRUE;
		SetEvent(self->hConnectEvent);
		
		for ( ; ; )
		{
			/* M */
			if ( (iSize = recv(self->sock, ubBuf, sizeof(ubBuf), 0)) == SOCKET_ERROR )
			{
				break;
			}
			
			/* Mobt@Ɋi[ */
			StreamBuf_SendData(&self->StmBufRecv, ubBuf, iSize);
			
			/* [ݐ */
			vsig_int(self->iIntNum);
		}
		
		/* MXbh~w */
		self->iConnection = FALSE;
		SetEvent(self->hSendEvent);
		
		/* MXbh~҂ */
		WaitForSingleObject(self->hDisconnectEvent, INFINITE);

		/* ؒf */
		closesocket(self->sock);
	}
	
	WSACleanup();
	
	return 0;
}



/* end of file */
