/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scihdl.h
 * @brief %jp{SCIpn[hEFAANZXw}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__renesas__scihal_h__
#define __HOS__renesas__scihal_h__


#define SCIHAL_INT_TIE		0x80				/* M݋ */
#define SCIHAL_INT_RIE		0x40				/* M݋ */
#define SCIHAL_INT_TEIE		0x04				/* M݋ */


/* SCIpn[hEFAANZXw */
typedef struct c_scihal
{
	volatile unsigned char	*pRegBase;			/* WX^̃x[XAhX */
	unsigned long			ulSysClock;			/* VXeNbNg */
} C_SCIHAL;


#ifdef __cplusplus
extern "C" {
#endif

/* SCIpn[hEFAANZXw */
void SciHal_Create(C_SCIHAL *self, void *pRegAddr, unsigned long ulSysClock);	/**< RXgN^ */
void SciHal_Delete(C_SCIHAL *self);												/**< fXgN^ */
void SciHal_Setup(C_SCIHAL *self);												/**< %jp{SCȈ} */
void SciHal_SetSpeed(C_SCIHAL *self, unsigned long ulSpeed);					/**< %jp{SCȊxݒ} */
void SciHal_Stop(C_SCIHAL *self);												/**< %jp{SCI̒~} */
int  SciHal_SendChar(C_SCIHAL *self, int c);									/**< %jp{1M} */
int  SciHal_RecvChar(C_SCIHAL *self);											/**< %jp{1M} */
void SciHal_EnableInterrupt(C_SCIHAL *self, unsigned char flag);				/**< %jp{݋} */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__renesas__scihal_h__ */


/* end of file */
