/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{Renesas H8/SHp SCIfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "scidrv_local.h"



/* M */
void SciDrv_IsrRx(VPARAM Param)
{
	C_SCIDRV *self;
	int c;
	
	self = (C_SCIDRV *)Param;
	
	/* M */
	while ( (c = SciHal_RecvChar(&self->SciHal)) >= 0 )
	{
		StreamBuf_SendChar(&self->StmBufRecv, c);
	}
	
	/* Ǎ݃VOi𔭐 */
	SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_READ);
}


/* end of file */
