/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{Renesas H8/SHp SCIfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "scidrv_local.h"


/** fXgN^ */
void SciDrv_Destructor(C_SCIDRV *self)
{
	void	*pMem;

	/* ݃T[rX[`폜 */
	SysIsr_Delete(self->hIsrRxErr);
	SysIsr_Delete(self->hIsrRx);
	SysIsr_Delete(self->hIsrTx);
	SysIsr_Delete(self->hIsrTxEnd);
	
	/* obt@폜 */
	pMem = StreamBuf_RefBufAddr(&self->StmBufRecv);
	StreamBuf_Delete(&self->StmBuf);
	SysMem_Free(pMem);
	
	/* eNXfXgN^ */
	SyncDrv_Destructor(&self->SyncDrv);
}


/* end of file */
