/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{Renesas H8/SHp SCIfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
* http://sourceforge.jp/projects/hos/
 */


#include "scidrv_local.h"


/* z֐e[u */
const T_DRVOBJ_METHODS SciDrv_Methods = 
	{
		{ SciDrv_Delete },
		SciDrv_Open,
		SciDrv_Close,
		SciDrv_IoControl,
		SciDrv_Seek,
		SciDrv_Read,
		SciDrv_Write,
		SciDrv_Flush,
	};


/**  */
HANDLE SciDrv_Create(void *pRegBase, int iIntNum, unsigned long ulSysClock, int iBufSize)
{
	C_SCIDRV *self;
	
	/* m */
	if ( (self = (C_SCIDRV *)SysMem_Alloc(sizeof(C_SCIDRV))) == NULL )
	{
		return HANDLE_NULL;
	}
	
	/* RXgN^Ăяo */
	if ( SciDrv_Constructor(self, &SciDrv_Methods, pRegBase, iIntNum, ulSysClock, iBufSize) != FILE_ERR_OK )
	{
		SysMem_Free(self);
		return HANDLE_NULL;
	}
	
	return (HANDLE)self;
}


/* end of file */
