/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{Renesas H8/SHp SCIfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "scidrv_local.h"


/** RXgN^ */
FILE_ERR SciDrv_Constructor(C_SCIDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pRegBase, int iIntNum, unsigned long ulSysClock, int iBufSize)
{
	FILE_ERR	ErrCode;
	void		*pMem;

	/* obt@pm */
	if ( (pMem = SysMem_Alloc(iBufSize)) == NULL )
	{
		return FILE_ERR_NG;
	}
	
	/* eNXRXgN^Ăяo */
	if ( (ErrCode = SyncDrv_Constructor(&self->SyncDrv, pMethods, SYNCDRV_FACTOR_NUM)) != FILE_ERR_OK )
	{
		SysMem_Free(pMem);
		return ErrCode;
	}

	/* oϐ */
	self->iOpenCount = 0;
	self->iIntNum    = iIntNum;

	/* SciHal  */
	SciHal_Create(&self->SciHal, pRegBase, ulSysClock);
	
	/* obt@ */
	StreamBuf_Create(&self->StmBufRecv, iBufSize, pMem);

	/* ݏo^ */
	self->hIsrRxErr = SysIsr_Create(iIntNum + 0, SciDrv_IsrRxErr, (VPARAM)self);
	self->hIsrRx    = SysIsr_Create(iIntNum + 1, SciDrv_IsrRx,    (VPARAM)self);
	self->hIsrTx    = SysIsr_Create(iIntNum + 2, SciDrv_IsrTx,    (VPARAM)self);
	self->hIsrTxEnd = SysIsr_Create(iIntNum + 3, SciDrv_IsrTxEnd, (VPARAM)self);
	
	return FILE_ERR_OK;
}


/* end of file */
