/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{Renesas H8/SHp SCIfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "scidrv_local.h"


/** N[Y */
void SciDrv_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj)
{
	C_SCIDRV	*self;
	
	/* upper cast */
	self = (C_SCIDRV *)pDrvObj;

	/* N[Y */
	if ( --self->iOpenCount == 0 )
	{
		SciHal_EnableInterrupt(&self->SciHal, 0);
		SciHal_Stop(&self->SciHal);
		StreamBuf_Clear(&self->StmBufRecv);
	}
	
	/* fBXNv^폜 */
	SysMem_Free(pFileObj);
}


/* end of file */
