/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  pc16550hdl_create.c
 * @brief %jp{PC16550pn[hEFAANZXw}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "pc16550hal_local.h"


/** %jp{PC16550̏} */
void Pc16550Hal_Setup(C_PC16550HAL *self)
{
	self->iTxFree = PC16550HAL_TXFIFO_SIZE;
	PC16550HAL_WRITE_IER(self, 0x00);		/* ݑS~ */
	PC16550HAL_WRITE_LCR(self, 0x03);		/* 8bit,mp,Xgbvrbg1bit*/
	PC16550HAL_WRITE_MCR(self, 0x03);		/* DTR/RTS ON */
	PC16550HAL_WRITE_FCR(self, 0xc1);		/* FIFO L/gK14 */
	PC16550HAL_WRITE_FCR(self, 0xc7);		/* FIFO Zbg */
}


/* end of file */
