/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  mn103scdrv_isr.c
 * @brief %jp{MN103V[Y VAC^[tF[XpfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "mn103scdrv_local.h"


/* M */
void Mn103ScDrv_IsrTx(VPARAM Param)
{
	C_MN103SCDRV	*self;
	
	self = (C_MN103SCDRV *)Param;
	
	/* ݗvNA */
	SysInt_Clear(self->iIntNumTx);
	
	/* M݂֎~ */
	SysInt_Disable(self->iIntNumTx);

	/* ݃VOi𔭐 */
	SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_WRITE);	
}


/* end of file */
