/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  mn103scdrv_isr.c
 * @brief %jp{MN103V[Y VAC^[tF[XpfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "mn103scdrv_local.h"


/* M */
void Mn103ScDrv_IsrRx(VPARAM Param)
{
	C_MN103SCDRV	*self;
	int				c;
	
	self = (C_MN103SCDRV *)Param;
	
	/* ݗvNA */
	SysInt_Clear(self->iIntNumRx);


	/* M */
	if ( (MN103SC_READ_STR(self) & 0x10) )
	{
		/* ǂݏo */	
		do
		{
			c = MN103SC_READ_RB(self);
			StreamBuf_SendChar(&self->StmBufRecv, c);
		} while ( (MN103SC_READ_STR(self) & 0x10) );
		
		/* Ǎ݃VOi𔭐 */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_READ);
	}
}


/* end of file */
