/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  mn103scdrv_destructor.c
 * @brief %jp{MN103V[Y VAC^[tF[XpfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "mn103scdrv_local.h"


/** fXgN^ */
void Mn103ScDrv_Destructor(C_MN103SCDRV *self)
{
	void	*pMem;

	/* ݃T[rX[`폜 */
	SysIsr_Delete(self->hIsrTx);
	SysIsr_Delete(self->hIsrRx);
	
	/* obt@폜 */
	pMem = StreamBuf_RefBufAddr(&self->StmBufRecv);
	StreamBuf_Delete(&self->StmBuf);
	SysMem_Free(pMem);
	
	/* eNXfXgN^ */
	SyncDrv_Destructor(&self->SyncDrv);
}


/* end of file */
