/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  mn103scdrv.h
 * @brief %jp{MN103V[Y VAC^[tF[XpfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__mn103scdrv_h__
#define __HOS__mn103scdrv_h__


#include "system/file/syncdrv_local.h"
#include "library/container/streambuf/streambuf.h"


/* UARThCo䕔 */
typedef struct c_mn103scdrv
{
	C_SYNCDRV		SyncDrv;		/* LN^^foCXhCop */
	
	void			*pRegBase;		/* WX^x[XAhX */
	int				iIntNumTx;		/* Mݔԍ */
	int				iIntNumRx;		/* Mݔԍ */
	SYSISR_HANDLE	hIsrTx;			/* M݃T[rX[`nh */
	SYSISR_HANDLE	hIsrRx;			/* M݃T[rX[`nh */
	
	int				iOpenCount;		/* I[vJE^ */
	
	C_STREAMBUF		StmBufRecv;		/* Mobt@ */
} C_MN103SCDRV;



#ifdef __cplusplus
extern "C" {
#endif

HANDLE Mn103ScDrv_Create(void *pRegBase, int iIntNumRx, int iIntNumTx, int iBufSize);	/**<  */
void   Mn103ScDrv_Delete(HANDLE hDriver);												/**< 폜 */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__mn103scdrv_h__ */


/* end of file */
