/** 
 * Hyper Operating System  Application Framework
 *
 * @file  jellyuartdrv_read.c
 * @brief %jp{JellyUart Ǎ}%en{JellyUart  read}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "jellyuartdrv_local.h"


/** %jp{Ǎ} */
FILE_SIZE JellyUartDrv_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size)
{
	C_JELLYUARTDRV		*self;
	C_SYNCFILE		*pFile;
	unsigned char	*pubBuf;
	FILE_ERR		ErrCode;
	FILE_SIZE		i;
	int				c;
	
	/* upper cast */
	self  = (C_JELLYUARTDRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;


	pubBuf = (unsigned char *)pBuf;

	/* ǍݏJn */
	if ( (ErrCode = SyncDrv_StartProcess(&self->SyncDrv, pFile, SYNCDRV_FACTOR_READ)) != FILE_ERR_OK )
	{
		return (FILE_SIZE)ErrCode;
	}

	/* Ǎ݃VOiUNA */
	SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_READ);
	
	for ( i = 0; i < Size; i++ )
	{
		/* ǂݏo */
#if 1
		while ( (c = StreamBuf_RecvChar(&self->StmBufRecv)) < 0 )
		{
			/* ubLO[hłȂΔ */
			if ( SyncFile_GetSyncMode(pFile, SYNCDRV_FACTOR_READ) != FILE_SYNCMODE_BLOCKING )
			{
				SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_READ, i);
				return i;
			}
			
			/* M҂ */
			SyncFile_WaitSignal(pFile, SYNCDRV_FACTOR_READ);
			
			/* Ǎ݃VOiNAăgC */
			SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_READ);
		}
#else
		while ( !(JELLYUART_REG_READ(self, JELLYUART_STATUS) & 0x01) )
			;
		c = JELLYUART_REG_READ(self, JELLYUART_DATA);
#endif
		
		/* ǂݏoi[ */	
		*pubBuf++ = (unsigned char)c;
	}
	
	/* ǂݏo */
	SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_READ, (VPARAM)i);

	return i;
}


/* end of file */
