/** 
 * Hyper Operating System  Application Framework
 *
 * @file  jellyuartdrv_create.c
 * @brief %jp{JellyUart IuWFNg}%en{JellyUart  create object}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "jellyuartdrv_local.h"


/** %jp{IuWFNg}%en{create object} */
HANDLE JellyUartDrv_Create(void *pRegBase, int iIntNumRx, int iIntNumTx, int iBufSize)
{
	C_JELLYUARTDRV *self;
	
	/* %jp{m}%en{Memory allocate} */
	if ( (self = (C_JELLYUARTDRV *)SysMem_Alloc(sizeof(C_JELLYUARTDRV))) == NULL )
	{
		return HANDLE_NULL;
	}
	
	/* %jp{RXgN^Ăяo}%en{constructor} */
	if ( JellyUartDrv_Constructor(self, NULL, pRegBase, iIntNumRx, iIntNumTx, iBufSize) != FILE_ERR_OK )
	{
		SysMem_Free(self);
		return HANDLE_NULL;
	}
	
	return (HANDLE)self;
}


/* end of file */
