/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  at91usartdrv_close.c
 * @brief %jp{ATMEL AT91V[YUSARTpfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "at91usartdrv_local.h"


/** N[Y */
void At91UsartDrv_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj)
{
	C_AT91USARTDRV	*self;
	C_SYNCFILE		*pFile;
	
	/* upper cast */
	self  = (C_AT91USARTDRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;

	/* N[Y */
	if ( --self->iOpenCount == 0 )
	{
		SysInt_Disable(self->iIntNum);
		StreamBuf_Clear(&self->StmBufRecv);
	}
	
	/* fBXNv^폜 */
	SyncFile_Delete((HANDLE)pFile);	
}


/* end of file */
