/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  streampipe.c
 * @brief %jp{Xg[pCv}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "streampipe_local.h"


/** %jp{} */
FILE_SIZE StreamPipe_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size)
{
	C_STREAMPIPE		*self;
	C_SYNCFILE			*pFile;
	const unsigned char	*pubData;
	FILE_ERR			ErrCode;
	FILE_SIZE			SendSize;
	FILE_SIZE			WriteSize;
		
	/* upper cast */
	self  = (C_STREAMPIPE *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;
	
	pubData = (const unsigned char *)pData;
	
	/* ݏJn */
	if ( (ErrCode = SyncDrv_StartProcess(&self->SyncDrv, pFile, SYNCDRV_FACTOR_WRITE)) != FILE_ERR_OK )
	{
		return (FILE_SIZE)ErrCode;
	}
	
	/* ݃VOiUNA */
	SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_WRITE);
	
	WriteSize = 0;
	while ( Size > 0 )
	{
		while ( (SendSize = StreamBuf_SendData(&self->StreamBuf, pubData, Size)) <= 0 )
		{
			/* ubLO[hłȂΔ */
			if ( SyncFile_GetSyncMode(pFile, SYNCDRV_FACTOR_WRITE) != FILE_SYNCMODE_BLOCKING )
			{
				SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_WRITE, (VPARAM)WriteSize);
				return WriteSize;
			}
			
			/* ݃VOi҂ */
			SyncFile_WaitSignal(pFile, SYNCDRV_FACTOR_WRITE);
			
			/* ݃VOiNAăgC */
			SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_WRITE);
		}
		
		/* |C^XV */
		pubData   += SendSize;
		WriteSize += SendSize;
		Size      -= SendSize;
		
		/* Ǎ݃VOis */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_READ);
	}
	
	/* ݏ */
	SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_WRITE, (VPARAM)WriteSize);
		
	return WriteSize;
}


/* end of file */
