/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  streampipe.c
 * @brief %jp{Xg[pCv}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "streampipe_local.h"


/** %jp{Ǎ} */
FILE_SIZE StreamPipe_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size)
{
	C_STREAMPIPE	*self;
	C_SYNCFILE		*pFile;
	unsigned char	*pubBuf;
	FILE_ERR		ErrCode;
	FILE_SIZE		RecvSize;
	FILE_SIZE		ReadSize;
	
	/* upper cast */
	self  = (C_STREAMPIPE *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;
	
	pubBuf = (unsigned char *)pBuf;
	
	/* ǍݏJn */
	if ( (ErrCode = SyncDrv_StartProcess(&self->SyncDrv, pFile, SYNCDRV_FACTOR_READ)) != FILE_ERR_OK )
	{
		return (FILE_SIZE)ErrCode;
	}
	
	/* Ǎ݃VOiUNA */
	SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_READ);
	
	ReadSize = 0;
	while ( Size > 0 )
	{
		/* ǂݏo */
		while ( (RecvSize = StreamBuf_RecvData(&self->StreamBuf, pubBuf, Size)) <= 0 )
		{
			/* ubLO[hłȂΔ */
			if ( SyncFile_GetSyncMode(pFile, SYNCDRV_FACTOR_READ) != FILE_SYNCMODE_BLOCKING )
			{
				SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_READ, (VPARAM)ReadSize);
				return ReadSize;
			}
			
			/* M҂ */
			SyncFile_WaitSignal(pFile, SYNCDRV_FACTOR_READ);
			
			/* Ǎ݃VOiNAăgC */
			SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_READ);
		}
		
		/* |C^XV */
		pubBuf   += RecvSize;
		ReadSize += RecvSize;
		Size     -= RecvSize;
		
		/* Ǎ݃VOis */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_WRITE);
	}
	
	/* ǂݏo */
	SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_READ, (VPARAM)ReadSize);
	
	return ReadSize;
}


/* end of file */
