/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  shell_main.c
 * @brief %jp{VF}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include <stdlib.h>
#include "shell_local.h"



/** C֐ */
int Shell_Main(int argc, char *argv[])
{
	C_SHELL *self;
	int		iCommandBufSize = SHELL_MAX_COMMAND;
	int 	iHistoryMax     = SHELL_MAX_HISTORY;
	int		iExecSimple     = 0;
	int		iExecTime       = 0;
	int		iInteractive    = 0;
	int		iExecString     = 0;
	char	*pszScript      = NULL;
	int     iExitCode       = 0;
	int		i;
	
	
	/* IvV */
	for ( i = 1; i < argc; i++ )
	{
		if ( argv[i][0] == '-' )
		{
			if ( strcmp(&argv[i][1], "i") == 0 )							/* C^NeBu[h */
			{
				iInteractive = 1;
			}
			else if ( strcmp(&argv[i][1], "exe") == 0 )						/* Ps */
			{
				iExecSimple = 1;
			}
			else if ( strcmp(&argv[i][1], "time") == 0 )					/* Ԍv */
			{
				iExecTime = 1;
			}
			else if ( strcmp(&argv[i][1], "s") == 0 && i+1 < argc )			/* s */
			{
				i++;
				iExecString = i;
			}
			else if ( strcmp(&argv[i][1], "buf") == 0 && i+1 < argc )		/* R}hobt@ݒ */
			{
				i++;
				iCommandBufSize = strtol(argv[i], NULL, 0);
			}
			else if ( strcmp(&argv[i][1], "his") == 0 && i+1 < argc )		/* qXgݒ */
			{
				i++;
				iHistoryMax = strtol(argv[i], NULL, 0);
			}
		}
		else
		{
			pszScript = argv[i];
		}
	}
	
	
	/* IuWFNg */
	if ( (self = Shell_Create(iCommandBufSize, iHistoryMax, iExecSimple, iExecTime)) == NULL )
	{
		return 1;
	}
	

	if ( iExecString > 0 )
	{
		/* s */
		self->pszCommanBuf[0] = '\0';
		for ( i = iExecString; i < argc; i++ )
		{
			strcat(self->pszCommanBuf, argv[i]);
			if ( i + 1 < argc )
			{
				strcat(self->pszCommanBuf, " ");
			}
		}
			
		/* s */
		iExitCode = Shell_ExecuteCommand(self, self->pszCommanBuf);
	}
	else if ( pszScript != NULL )
	{
		/* XNvgs */
		iExitCode = Shell_ExecuteScript(self, pszScript);
	}
	
	/* C^NeBu[h */
	if ( iInteractive )
	{
		iExitCode = Shell_Interactive(self);
	}
	
	/* IuWFNg폜 */
	Shell_Delete(self);
	
	return iExitCode;
}



/* end of file */
