/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǽ                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"


/*  */
ER cre_tsk(
		ID           tskid,		/* оݤΥIDֹ */
		const T_CTSK *pk_ctsk)	/* 줿ѥåȤؤΥݥ */
{
	ER ercd;

	/* ID ϰϥå */
#ifdef HOS_ERCHK_E_ID
	if ( tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* Ͽǽå */
#ifdef HOS_ERCHK_E_OBJ
	if ( KERNEL_TSKID_TO_TCB_RAM(tskid) != NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_OBJ;	/* ϿѤ */
	}
#endif
	
	/*  */
	ercd = kernel_cre_tsk(tskid, pk_ctsk);

	mknl_unl_sys();	/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
