/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ޥե                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sem.h"



/* ޥե񸻤ֵ */
ER sig_sem(
		ID semid)		/* ޥեֵоݤΥޥեIDֹ */
{
	const T_KERNEL_SEMCB_ROM *semcb_rom;
	T_KERNEL_SEMCB_RAM *semcb_ram;
	T_MKNL_TCB *mtcb;
	
	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( semid < KERNEL_TMIN_SEMID || semid > KERNEL_TMAX_SEMID )
	{
		return E_ID;
	}
#endif
	
	mknl_loc_sys();	/* ƥΥå */
	
	semcb_ram = KERNEL_SEMID_TO_SEMCB_RAM(semid);
	
	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( semcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif
	
	semcb_rom = semcb_ram->semcb_rom;
	
	/* 塼󥰥Сեå */
#ifdef HOS_ERCHK_E_QOVR
	if ( semcb_ram->semcnt >= semcb_rom->maxsem )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_QOVR;
	}
#endif
	
	mtcb = mknl_ref_qhd(&semcb_ram->que);	/* ԤƬ饿Ф */
	if ( mtcb != NULL )
	{
		/* ԤԤ */
		mknl_rmv_que(mtcb);						/* ޥեԤ󤫤 */
		mknl_rmv_tmout(mtcb);					/* ॢԤ󤫤 */
		mknl_wup_tsk(mtcb, E_OK);				/* Ԥ */
		
		mknl_exe_dsp();		/* ǥѥåμ¹ */
		mknl_exe_tex();		/* 㳰μ¹ */
	}
	else
	{
		semcb_ram->semcnt++;	/* ޥեֵ */
	}

	mknl_unl_sys();	/* ƥΥå */

	return E_OK;	/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
