/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ Ĺס                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpf.h"
#include "knl_mem.h"



/* Ĺסκ */
ER del_mpf(
		ID mpfid)	/* оݤθĹסIDֹ */
{
	const T_KERNEL_MPFCB_ROM *mpfcb_rom;
	T_KERNEL_MPFCB_RAM *mpfcb_ram;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mpfid < KERNEL_TMIN_MPFID || mpfid > KERNEL_TMAX_MPFID )
	{
		return E_ID;	/* ID */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	mpfcb_ram = KERNEL_MPFID_TO_MPFCB_RAM(mpfid);
	mpfcb_rom = mpfcb_ram->mpfcb_rom;

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mpfcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif
	
	/* Ԥβ */
	mknl_clr_que(&mpfcb_ram->que);
	
	/* β */
	kernel_fre_mem(mpfcb_rom->mpf);	
	kernel_fre_mem(mpfcb_ram);
	KERNEL_MPFID_TO_MPFCB_RAM(mpfid) = NULL;
	
	mknl_exe_dsp();		/* ǥѥåμ¹ */
	mknl_exe_tex();		/* 㳰μ¹ */
	
	mknl_unl_sys();	/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
