/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ åХåե                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"



/* åХåե(IDֹ漫ưդ) */
ER_ID acre_mbf(
		const T_CMBF *pk_cmbf)	/* åХåե줿ѥåȤؤΥݥ */
{
	ID mbfid;
	ER ercd;

	mknl_loc_sys();	/* ƥΥå */

	/* ѲǽIDθ */
	for ( mbfid = KERNEL_TMAX_MBFID; mbfid >= KERNEL_TMIN_MBFID; mbfid-- )
	{
		if ( KERNEL_MBFID_TO_MBFCB_RAM(mbfid) == NULL )
		{
			break;
		}
	}
	
	/* IDֹ­å */
#ifdef HOS_ERCHK_E_NOID
	if ( mbfid < KERNEL_TMIN_MBFID )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOID;	/* IDֹ­ */
	}
#endif

	/* åХåե */
	ercd = kernel_cre_mbf(mbfid, pk_cmbf);
	if ( ercd != E_OK )
	{
		mknl_unl_sys();	/* ƥΥå */
		return (ER_ID)ercd;
	}
	
	mknl_unl_sys();	/* ƥΥå */

	return (ER_ID)mbfid;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
