/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ץåݲݡͥ (Ω H8/300H )                      */
/*    ƥ                                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


				.h8300h



				.text
				.align 2



				.global	_hospac_dis_int		/* ߶ػ */
				.global	_hospac_ena_int		/* ߵ */
				.global	_hospac_cre_ctx_asm	/* ¹ԥƥȤκ */
				.global	_hospac_swi_ctx		/* ¹ԥƥȤ */
				.global	_hospac_set_tex		/* 㳰¹ */



/************************************************
  ߶ػ
  void hospac_dis_int(void)
*************************************************/
_hospac_dis_int:
				orc	#0xc0, ccr			/* ߤζػ */
				rts


/************************************************
  ߵ
  void hospac_ena_int(void)
*************************************************/
_hospac_ena_int:
				mov.b	@_kernel_h83_imsk:16, r0l
				ldc.b	r0l, ccr		/* ߤε */
				rts



/************************************************
  ¹ԥƥȥȥ꡼ɥ쥹
*************************************************/
ctx_entry:	
				mov.l	er4, er0		/* ¹Իѥ᡼ */
				jmp		@er5			/* ¹ԥɥ쥹˥ */


/************************************************
  ¹ԥƥȤκ
  void hospac_cre_ctx_asm(
			T_HOSPAC_CTXINF *pk_ctxinf,			륳ƥ
			VP              sp,					åݥ
			void            (*task)(VP_INT),	¹ԥɥ쥹
			VP_INT          exinf				¹Իѥ᡼
		)
*************************************************/
_hospac_cre_ctx_asm:
				mov.w   #ctx_entry, r3	/* ¹ԥȥ꡼ݥȤ */
				mov.w   r3, @-er1
				mov.l   @(2:16,er7), er3	/* ¹Իѥ᡼μФ */
				mov.l   er3, @-er1		/* ¹Իѥ᡼Ǽ (er4ʬ) */
				mov.l   er2, @-er1		/* ¹ԥɥ쥹Ǽ (er5 ʬ) */
				sub.l   #4, er1			/* er6ʬ */

#if ( __GNUC__ > 3 || ( __GNUC__ == 3 && __GNUC_MINOR__ >= 3))
				mov.w   r1, @(0:16, er0)	/* åݥ󥿤γǼ */
#else
				mov.l   er1, @(0:16, er0)	/* åݥ󥿤γǼ */
#endif	/* 3.3ʹߤǤϡ-mnǥݥ󥿤WORDȤʤ */

				rts


/************************************************
  ¹ԥƥȤ
  void hospac_swi_ctx(
			T_HOSPAC_CTXINF *pk_pre_ctxinf,		ߤΥƥȤ¸
			T_HOSPAC_CTXINF *pk_nxt_ctxinf		ڤؤ륳ƥ
		)
*************************************************/
_hospac_swi_ctx:
				push.l	er4
				push.l	er5
				push.l	er6

#if ( __GNUC__ >=3 && __GNUC_MINOR__ >=3 )
				mov.w	r7,@(0, er0)	/* åݥ¸ */
				mov.w	@(0, er1), r7	/* åݥ */
#else
				mov.l	er7,@(0, er0)	/* åݥ¸ */
				mov.l	@(0, er1), er7	/* åݥ */
#endif	/* 3.3ʹߤǤϡ-mnǥݥ󥿤WORDȤʤ */

				pop.l	er6
				pop.l	er5
				pop.l	er4
				rts



				.end


/* -------------------------------------------------------------------------*/
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* -------------------------------------------------------------------------*/
