/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå ƥִ                           */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_sys_h__
#define __HOS_V4__knl_sys_h__


#include "knl_hos.h"
#include "knl_tsk.h"


/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* С */
#define TKERNEL_MAKER	0x0008				/* ᡼(Ŀ) */
#define TKERNEL_PRID	0x0000				/* ͥμֹ(̤) */
#define TKERNEL_SPVER	0x5401				/* ITRONͤΥС(ITRON Ver 4.01) */
#define TKERNEL_PRVER	0x0101				/* ͥΥСֹ (HOS-V4 Ver 1.01) */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/* С */
typedef struct t_rver
{
	UH    maker;		/* ͥΥ᡼ */
	UH    prid;			/* ͥμֹ */
	UH    spver;		/* ITRONͤΥС */
	UH    prver;		/* ͥΥСֹ */
	UH    prno[4];		/* ͥʤδ */
} T_RVER;



/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* ƥִǽ */
ER      rot_rdq(PRI tskpri);						/* ̤ͥβž */
#define irot_rdq	rot_rdq							/* ̤ͥβž(󥿥ƥѥޥ) */
ER      get_tid(ID *p_tskid);						/* ¹Ծ֥IDλ */
#define iget_tid	get_tid							/* ¹Ծ֥IDλ(󥿥ƥѥޥ) */
ID      kernel_get_tid(T_KERNEL_TCB_RAM *tcb_ram);	/* IDμ(ͥؿ) */
ER      loc_cpu(void);								/* CPUå֤ؤΰܹ */
#define iloc_cpu	loc_cpu							/* CPUå֤ؤΰܹ(󥿥ƥѥޥ) */
ER      unl_cpu(void);								/* CPUå֤β */
#define iunl_cpu	unl_cpu							/* CPUå֤β(󥿥ƥѥޥ)  */
ER      dis_dsp(void);								/* ǥѥåζػ */
ER      ena_dsp(void);								/* ǥѥåε */
BOOL    sns_ctx(void);								/* ƥȤλ */
BOOL    sns_loc(void);								/* CPUå֤λ */
BOOL    sns_dsp(void);								/* ǥѥåػ߾֤λ */
BOOL    sns_dpn(void);								/* ǥѥåα֤λ */

/* ƥ๽ǽ */
ER      ref_ver(T_RVER *pk_rver);					/* Сֹλ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_sys_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
