<?php
// vim: foldmethod=marker
/**
 *	
 *
 *	@author		ITOH Takashi
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_XeblogCategory
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		ITOH Takashi
 *	@access		public
 *	@package	Sample
 */

class Xanhte_XeblogPhotoManager extends Xanhte_AppManager
{
	function Xanhte_XeblogPhotoManager(&$backend){
		$this->Xanhte_AppManager(&$backend);
	}

	// åץɾɲ
	// @param åץɾ
	function addImageFiles($uploadfiles, $blog_id=0, $cat_id=0){
		global $xoopsUser ;
		$now = time();
		$ret = array();
		foreach($uploadfiles as $file){
			$file['blog_id'] = $blog_id ;
			$file['cid'] = $cat_id;
			$file['submitter'] = $xoopsUser->uid();
			$file['date'] = $now ;
			$file['status'] = 1 ;
			$image_obj =& new Xanhte_XeblogPhoto($this->backend, null, null, $file);
			$ret[$file['filename']] = $image_obj->add();
		}
		return $ret ; 
	}

	/* åץɤΥͥޤ
	 * @param åץɤեξ
	 * @param åץɥեΥѥ array('filename', 'ext', 'res_x', 'res_y')
	 * @param 륵ͥ array('');
	 */
	function copy2Thumbnail(&$uploadfiles, $upload_path){
		// 
		global $xoopsModuleConfig ;
		global $myalbum_makethumb , $myalbum_thumbsize , $myalbum_thumbrule ;
		$myalbum_makethumb = true ;
		$thumb_prop = array(
			'size' => $xoopsModuleConfig['xeblog_myalbum_thumbsize'] ,
			'rule' =>$xoopsModuleConfig['xeblog_myalbum_thumbrule'] );
		
		$src_path = $upload_path ;
		
		foreach($uploadfiles as $key=>$file_prop){
			$thumb_path = sprintf('%s/thumbnail', $upload_path);
			$file_prop['ext'] = str_replace('.' , '' , $file_prop['ext']);
			$result = Xanhte_Util::createThumbnailImage($upload_path, $thumb_path, $file_prop, $thumb_prop, $xoopsModuleConfig['xeblog_myalbum_thumbmk']);
			$uploadfiles[$key]['has_thumb'] = ($result==1) ? 1 : 0 ;
		}
	}
	

	/* եDBΤݽʿƻ˥ץӥ塼ǥåץɤϤǤ᤿
	 * @param åץɥեΥѥ
	 * @param ¹Ԥ%(percentage)
	 * @param õ륿ߥ󥰡ʥǥե2blog_idγꤷʤΤϾõ
	 */
	function garbageFiles($upload_path, $frequency=10, $limit_time=7200){
		intval($frequency) >= 100 and $frequency=100 ;
		intval($frequency) < 1 and $frequency=0;
		// ¹Ԥ뤫ݤ
		$rand = rand(1,100);
		if( $rand  > $frequency ){
			return null ;
		}
		$now = time();
		// Ethna_AppSearchObjectMySQLؿȤʤΤǡѹܤɲäƤ
		// ɡ©ʼȤäƤǤSQL񤤤ʡȻפޤ
		$so =& new Ethna_AppSearchObject(10, OBJECT_CONDITION_GT) ; // blog_id
		$so_date =& new Ethna_AppSearchObject($now - $limit_time , OBJECT_CONDITION_LT) ;
		$so->addObject('date', $so_date, OBJECT_CONDITION_AND); 
		$remove_files =& $this->getObjectList('XeblogPhoto', array('blog_id)'=>$so));

		foreach($remove_files[1] as $fileobj){
			$file = $fileobj->get('filename') . $fileobj->get('ext') ;
			$this->_removeImageRealFile($upload_path, $file) ;
			$fileobj->remove();
		}
	}
	
	
	
	// ֥ȥ˻ȤƤե
	// @access private
	function getBlogImages($blog_id){
		global $xoopsUser ;
		
		$order = array('date'=>'ASC');
		$filter = array(
			'blog_id' => new Ethna_AppSearchObject($blog_id, OBJECT_CONDITION_EQ)
		);
		$images =& $this->getObjectPropList('XeblogPhoto', null, $filter, $order);
		// ͥĴ
		foreach($images[1] as $key=>$imageProp){
			list( $images[1][$key]['tag_x'] , $images[1][$key]['tag_y'] ) = 
			  $this->_calcThumbnailSize( $imageProp['res_x'] , $imageProp['res_y'] ) ;
		}		
		return $images;
	}

	// ɽѤĴ
	// (ͥ뤬뤫ͥ륵꾮ФΤޤޡ礭нĤ򥵥ͥ륵˻꤬)	
	// @access protected
	function _calcThumbnailSize($res_x, $res_y){
		require_once 'XanhteLib/xoops/myalbum-P_functions.php';
		global $myalbum_thumbsize , $myalbum_thumbrule , $xoopsModuleConfig ;
		$myalbum_thumbsize = $xoopsModuleConfig['xeblog_myalbum_thumbsize'];
		$myalbum_thumbrule = $xoopsModuleConfig['xeblog_myalbum_thumbrule'];
		list($new_x, $new_y) = myalbum_get_thumbnail_wh( $res_x , $res_y ) ;
		if($new_x < $res_x && $new_y < $res_y ){
			return array($new_x, $new_y);
		}
		return array($res_x, $res_y);
	}
	
	
	
	/** filename꤬˺
	 * @access public
	 * @param filename
	 * @return boolean (Ǥк)
	 **/
	function removeImageByFilename($filename, $upload_path=''){
	
		if(strlen($filename)!=32){
			return false ;
		}
		$image =& new Xanhte_XeblogPhoto(&$this->backend, 'filename', $filename);
		$ext = $image->get('ext');
		$ret = $image->remove();
		$this->_removeImageRealFile($upload_path, $filename.$ext);
		return $ret ;
	}
	
	/* ¥եä 
	* @access protected
	* @param string åץɥѥ
	* @param string ե̾ʳĥդ
	* @return null
	*/
	function _removeImageRealFile($upload_path, $file){
		global $xoopsModuleConfig ;
		
		empty($upload_path) and $upload_path = XOOPS_ROOT_PATH .'/'. $xoopsModuleConfig['xeblog_myalbum_photospath'] ;
		$filepath = $upload_path .'/'. $file;
		$filepath_thumb = sprintf('%s/thumbnail/%s', $upload_path, $file);
		if(file_exists($filepath)){
//			echo "delete $filepath \n";
			unlink($filepath);
		}
		if(file_exists($filepath_thumb)){
//			echo "delete $filepath_thumb \n";
			unlink($filepath_thumb);
		}
	}
	
	/* ƻ˥ƥݥBLOG_ID鿷BLOG_ID
	* @access public
	* @param string ƥݥΥ֥ID
	* @param string ֥ID
	* @return null åץɤĿ
	*/
	function updateTmpBlogid($tmp_blog_id, $new_blog_id){
	
		// SQLȯǤäƤޤä
		global $xoopsDB ;
		$sql = sprintf('update %s set blog_id=%d where blog_id=\'%s\'', $xoopsDB->prefix('xeblog_photo'), $new_blog_id , $tmp_blog_id) ;
		$xoopsDB->query($sql);
		$num = $xoopsDB->getAffectedRows();
		return $num ;
	}
	
	
	/* 󤫤ȯåJS
	 * ޥ͡Javascriptȥåץɻλ˻
	 * @access public
	 * @param array ᡼
	 * @return array Javascriptޤ
	 */
	function convertImageinfo2Imagejs($image){
		global $xoopsModuleConfig ;
		
		$image_js = array();
		foreach(array('left','center','right') as $position){
			foreach(array('contents', 'description') as $field){
				$image_js['big'][$field][$position] = sprintf('<img onclick="javascript:xoopsCodeSmilie(\'%s\',\'[img align=%s]%s%s/%s%s[/img]\');" src="%s/modules/xanhte/images/myalbum_imagemanager/alignbig%s.gif" alt="%s" title="%s" />',
															  $field, $position, XOOPS_URL, $xoopsModuleConfig['xeblog_myalbum_photospath'], $image['filename'], $image['ext'],
															  XOOPS_URL, $position, $position, $position );
				// ͥ
				$thumb_file_path = sprintf('%s%s/%s%s',XOOPS_ROOT_PATH , $xoopsModuleConfig['xeblog_myalbum_photospath'], $image['filename'], $image['ext']) ;
				if(file_exists($thumb_file_path)){
					$image_js['thumb'][$field][$position] = sprintf('<img onclick="javascript:xoopsCodeSmilie(\'%s\',\'[url=%s%s/%s%s][img align=%s]%s%s/thumbnail/%s%s[/img][/url]\');" src="%s/modules/xanhte/images/myalbum_imagemanager/align%s.gif" alt="%s" title="%s" />',
																	$field, XOOPS_URL, $xoopsModuleConfig['xeblog_myalbum_photospath'], $image['filename'], $image['ext'], $position,
																	XOOPS_URL, $xoopsModuleConfig['xeblog_myalbum_photospath'], $image['filename'], $image['ext'],
																	XOOPS_URL, $position, $position, $position ) ;
				}
			}
		}
		
		return $image_js;
	}
	
	
	/**
	 * Ƕβ
	 * @access public
	 * @param int 
	 * @param boolean ȥαĤθ
	 * @return array Javascriptޤ
	 */
	function getRecentImages($num, $permission=false){
		global $xoopsDB, $xoopsModuleConfig ;
		
		$filter = $this->xeblogE->getXeblogFilter(0, true);
		
		if($permission){
			// category
			if($xoopsModuleConfig['category_permission']){
				$field = $xoopsDB->prefix('xeblog.cat_id') ;
				$filter[$field] = $this->xeblogC->getAllowedCategorySO();
			}
		}
		
		
		
	}
}


// }}}

// {{{ Xanhte_Category
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */
class Xanhte_XeblogPhoto extends Xanhte_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥
	 */
        var $table_def = array(
			'xeblog_photo' => array(
				'primary' => true 
				)
	    );
	    
        var $prop_def = array(
			'filename'=> array(
				'primary' => true,
				'key' => true,
				'seq' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'filename',
				'prop_name' => 'åץɥե̾(body)' ,
				),
			'blog_id'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'blog_id',
				'prop_name' => 'ƥοƥƥ' ,
				),
			'cid'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'cid',
				'prop_name' => 'ƥID' ,
				),
			'ext'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'ext',
				'prop_name' => 'åץɥե̾(ɥåդĥ)' ,
				),
			'res_x'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'res_x',
				'prop_name' => '' ,
				),
			'res_y'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'res_y',
				'prop_name' => '' ,
				),
			'submitter'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'submitter',
				'prop_name' => 'Ƽԥ桼ID' ,
				),
			'has_thumb'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'has_thumb',
				'prop_name' => 'ͥäƤ뤫ɤ' ,
				),
			'status'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'status',
				'prop_name' => 'ɽơ' ,
				),
			'date'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'date',
				'prop_name' => '' ,
				),
			);

	/**#@-*/	    
	    
	/**#@-*/

	/**
	 *	XeblogPhoto饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_XeblogPhoto(&$backend, $key_type = null, $key = null, $prop = null)
	{
		$this->Xanhte_AppObject(&$backend, $key_type, $key, $prop);
	    // ֥ȼԤϤ˵Ҥޤ
	}
	
	
	/*
	 * Ѥ$prop_defɲäեɤɲäץ饰
	 * (νϤʤѥˡʤΤǿʤ褦)
	 */
	function _SQLPlugin_SearchPropDef(){
		global $xoopsDB ;
		
		$search_prop_def = array(
			'blog_id)' => array(
				'name' => 'length',
				'type'=> VAR_TYPE_INT,
				'table' => 'CHAR_LENGTH('. $xoopsDB->prefix('xeblog_photo'),
				),
		);
		return $search_prop_def ;
	}
}
// }}}

?>
