<?php
// vim: foldmethod=marker
/**
 *	Sample_Rss.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_RssManager
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */

class Xanhte_RssManager extends Ethna_AppManager
{
    
	/**
	 *	XML˺ŬHTTP-header
	 *
	 *	@access	public
	 *  @param string RSSμ(RDF/RSS/ATOM)
	 */
	function headerXML($xml_type, $output_charset=''){
		if( empty($output_charset)  ){
			$output_charset = function_exists('mb_convert_encoding') ? 'UTF-8' : _CHARSET ;
		}
		switch($xml_type){
		  case 'rdf' :
			//		 header('Content-type: text/rdf+xml; charset='.$charset);
			header('Content-type: text/xml; charset='.$output_charset);
			break ;
		  case 'atom' :
			header('Content-type: text/xml; charset='.$output_charset);
			break ;
		  case 'rss' :
		  default :
			header('Content-type: text/xml; charset='.$output_charset);
			break ;
		}
	}
	
	/**
	 *	DATA顢XML˥ѡ
	 *
	 *	@access	public
	 *  @param array Ѵǡ Υ᥽åѤƤ뤳
	  ɬפʥǡ
  $xml_item = array(
	  array(
        ["dirname"]=>
          string(6) "weblog"
        ["resource"]=>
          string(61) "http://127.0.0.1/xoops2/modules/weblog/details.php?blog_id=10"
        ["title"]=>
          string(33) "ư˺줿"
        ["author"]=>
          string(5) "admin"
        ["category"]=>
          string(15) ""
        ["description"]=>
          string(340) ".............."
        ["created_unixtime"]=>
          string(10) "1093756194"
        ["published_unixtime"]=>
          string(10) "1093756194"
	  ),
	 *  @param string RSSμ(RDF/RSS/ATOM)
	 *  @param array ѴXML
	 *	@return	string XML
	 */
	function parseXML($xml_item, $xml_type, $dirname){
		global $config_handler, $module_handler , $xoopsConfig ;
		
		$output_charset = function_exists('mb_convert_encoding') ? 'UTF-8' : _CHARSET ;
		$xml_item = Xanhte_Util::con_enc( $xml_item, $output_charset, _CHARSET);
		$xoopsConfig = Xanhte_Util::con_enc( $xoopsConfig, $output_charset, _CHARSET);
		$xoopsMetaConfig =& Xanhte_Util::con_enc($config_handler->getConfigsByCat(XOOPS_CONF_METAFOOTER), $output_charset, _CHARSET);
		
		// get Module information
		$modinfo =& $module_handler->getByDirname($dirname);
		switch($xml_type){
		  case 'rdf' :
			return $this->_parseRDF($xml_item, $xoopsMetaConfig, $modinfo, $output_charset);
			break ;
		  case 'atom' :
			return $this->_parseATOM($xml_item, $xoopsMetaConfig, $modinfo, $output_charset);
			break ;
		  case 'rss' :
		  default :
			return $this->_parseRSS($xml_item, $xoopsMetaConfig, $modinfo, $output_charset);
			break ;
		}
	}
	
	
	/**
	 *	DATA顢RDF˥ѡ
	 *
	 *	@access	private
	 *  @param array Ѵǡ
	 *  @param array ѴXML
	 *	@return	string RDFXML
	 */
	function _parseRDF($xml_item, $xoopsMetaConfig, $modinfo, $output_charset){
		
		// add item
		global $xoopsConfig ;
		
		$myts = new MyTextSanitizer ;
		$sign = ( $xoopsConfig['default_TZ'] >= 0 ) ? "+" : "-" ;

		$item_data = array();
		foreach($xml_item as $var) {
			$item = array() ;
			$data_excerpt = "" ;
			$item = array(
				'title' => $var['title'],
				'link' => $var['resource'],
				'dc:date' => date("Y-m-d" , $var['created_unixtime'] ) . "T" .date("H:i:s" , $var['created_unixtime'] ) . $sign . sprintf( "%02d:00",abs($xoopsConfig['default_TZ']) ),
				'dc:creator' => $var['author'],
				'dc:subject' => $var['category'],
				'description' => strip_tags($myts->xoopsCodeDecode($var['description'])) ,
				//		     'content:encoded' => sprintf('<![CDATA[%s]]>', $myts->xoopsCodeDecode($var['description'])),
				'_attributes' => array( "rdf:about"=> htmlspecialchars($var['resource'])) ,
				);
			$item_data[] = $item ;
		}

		$options = array(
			"mode" => "simplexml" ,
			"indent"    => "    ",
			"linebreak" => "\n",
			"typeHints" => false,
			"addDecl"   => true,
			"encoding"  => $output_charset,
			"rootName"  => "rdf:RDF",
			"rootAttributes" => array(
				"xmlns" => "http://purl.org/rss/1.0/",
				"xmlns:rdf" => "http://www.w3.org/1999/02/22-rdf-syntax-ns#",
				"xmlns:dc" => "http://purl.org/dc/elements/1.1/",
				"xmlns:sy" => "http://purl.org/rss/1.0/modules/syndication/",
				"xmlns:admin" => "http://webns.net/mvcb/",
				"xmlns:content" => "http://purl.org/rss/1.0/modules/content/"
				),
			"defaultTagName" => "item",
			"attributesArray" => "_attributes",
			'cdata' => false,
			);
		
		$data["channel"] = array(
			"title" => $xoopsConfig['sitename']." - ".Xanhte_Util::con_enc($modinfo->name(), $output_charset, _CHARSET ),
			"link"  => sprintf('%s/modules/%s/', XOOPS_URL , $modinfo->dirname()) ,
			"description" => $xoopsMetaConfig['meta_description'],
			"dc:language" => _LANGCODE ,
			"dc:creator" => $xoopsMetaConfig['meta_author'],
			"dc:language" => _LANGCODE ,
			"_attributes" => array("rdf:about" => sprintf('%s/modules/%s/', $xoopsConfig['xoops_url'] ,$modinfo->dirname()) )
			);
		
		for( $item_num=0 ; $item_num<count($item_data) ; $item_num++ ){
			$data["channel"]["items"]["rdf:Seq"]["rdf:li"][$item_num]["_attributes"]["rdf:resource"] = htmlspecialchars($item_data[$item_num]["link"]) ;
			$data[] = $item_data[$item_num] ;
		}
		
		require_once 'XML/Serializer.php' ;
		$Serializer = &new XML_Serializer($options);
		$status = $Serializer->serialize($data);
		if (PEAR::isError($status)){
			die($status->getMessage());
		}
		
		return $Serializer->getSerializedData();
	}
	
	/**
	 *	DATA顢RSS2.0˥ѡ
	 *
	 *	@access	private
	 *  @param array Ѵǡ
	 *  @param array ѴXML
	 *	@return	string RSS2.0XML
	 */
	function _parseRSS($xml_item, $xoopsMetaConfig, $modinfo, $output_charset){
		
		// add item
		global $xoopsConfig ;
		
		$myts = new MyTextSanitizer ;
		$sign = ( $xoopsConfig['default_TZ'] >= 0 ) ? "+" : "-" ;

		foreach($xml_item as $var) {
			$item = array() ;
			$data_excerpt = "" ;
			$item = array(
				'title' => $var['title'],
				'link' => $var['resource'],
				'dc:date' => date("Y-m-d" , $var['created_unixtime'] ) . "T" .date("H:i:s" , $var['created_unixtime'] ) . $sign . sprintf( "%02d:00",abs($xoopsConfig['default_TZ']) ),
				'dc:creator' => $var['author'],
				'dc:subject' => $var['category'],
				'description' => strip_tags($myts->xoopsCodeDecode($var['description'])) ,
				);
			$item_data[] = $item ;
		}
		
		$options = array(
			"mode" => "simplexml" ,
			"indent"    => "    ",
			"linebreak" => "\n",
			"typeHints" => false,
			"addDecl"   => true,
			"encoding"  => $output_charset,
			"rootName"  => 'rss',
			"rootAttributes" => array('version'=>"2.0", 'xmlns:dc'=>"http://purl.org/dc/elements/1.1/", 'xmlns:sy'=>"http://purl.org/rss/1.0/modules/syndication/", 'xmlns:admin'=>"http://webns.net/mvcb/",  'xmlns:rdf'=>"http://www.w3.org/1999/02/22-rdf-syntax-ns#"),
			"defaultTagName" => "item",
			"attributesArray" => "_attributes",
			'cdata' => false,
			);
		
		$data["channel"] = array(
			"title" => $xoopsConfig['sitename']." - ". Xanhte_Util::con_enc($modinfo->name(), $output_charset, _CHARSET ),
			"link"  => sprintf('%s/modules/%s/', XOOPS_URL , $modinfo->dirname()) ,
			"description" => $xoopsMetaConfig['meta_description'],
			"dc:language" => _LANGCODE ,
			"dc:creator" => $xoopsMetaConfig['meta_author'],
			"item" => $item_data,
			);
		
		require_once 'XML/Serializer.php' ;
		$Serializer = &new XML_Serializer($options);
		$status = $Serializer->serialize($data);
		if (PEAR::isError($status)){
			die($status->getMessage());
		}
		
		return $Serializer->getSerializedData();
	}
	
	/**
	 *	DATA顢ATOM˥ѡ
	 *
	 *	@access	private
	 *  @param array Ѵǡ
	 *  @param array ѴXML
	 *	@return	string RSS2.0XML
	 */
	function _parseATOM($xml_item, $xoopsMetaConfig, $modinfo, $output_charset){
		
		// add item
		global $xoopsConfig ;
		
		$myts = new MyTextSanitizer ;
		$sign = ( $xoopsConfig['default_TZ'] >= 0 ) ? "+" : "-" ;

		foreach($xml_item as $var) {
			$item = array() ;
			$data_excerpt = "" ;
			$date = date("Y-m-d" , $var['created_unixtime'] ) . "T" .date("H:i:s" , $var['created_unixtime'] ) . $sign . sprintf( "%02d:00",abs($xoopsConfig['default_TZ']) ) ;
			$item = array(
				'title' => $var['title'],
				'link' => array(
					'_attributes' => array(
						'url' => htmlspecialchars($var['resource']),
						'type' => 'text/html',
						'rel' => 'alternate',
						),
					),
				'id' => $var['resource'] ,
				'issued' => $date ,
				'modified' => $date ,
				'created' => $date ,
				'author' => array(
					'name' => $var['author'],
					),
				'dc:subject' => $var['category'],
				'content' => array(
					strip_tags($myts->xoopsCodeDecode($var['description'])) ,
					'_attributes' => array(
						'mode' => "escaped",
						'type' => "text/html",
						'xml:lang' => $output_charset ,
						)
					),
				);
			$item_data[] = $item ;
		}
		
		$options = array(
			"mode" => "simplexml" ,
			"indent"    => "    ",
			"linebreak" => "\n",
			"typeHints" => false,
			"addDecl"   => true,
			"encoding"  => $output_charset,
			"rootName"  => 'feed',
			"rootAttributes" => array('version'=>"0.3", 'xml:lang'=>$output_charset, 'xmlns'=>"http://purl.org/atom/ns#",  'xmlns:dc'=>"http://purl.org/dc/elements/1.1/"),
			"defaultTagName" => "entry",
			"attributesArray" => "_attributes",
			'cdata' => false,
			);
		
		$data = array(
			'title' => $xoopsConfig['sitename']." - ". Xanhte_Util::con_enc($modinfo->name(), $output_charset, _CHARSET ),
			'link' => array(
				'_attributes'=>array(
					'rel' => 'alternate',
					'type'=> 'text/html',
					'href'=> sprintf('%s/modules/%s/', XOOPS_URL , $modinfo->dirname()) ,
					),
				),
			'modified' => date("Y-m-d" , $var['created_unixtime'] ) . "T" .date("H:i:s" , $var['created_unixtime'] ) . $sign . sprintf( "%02d:00",abs($xoopsConfig['default_TZ']) ),
			'author' => array(
				'name' => $xoopsMetaConfig['meta_author'],
				),
			'tagline' => Xanhte_Util::con_enc($modinfo->name(), $output_charset, _CHARSET ),
			'generator' => array(
				$xoopsConfig['sitename'],
				'_attributes' => array(
					'url' => XOOPS_URL
					)
				),
			'entry' => $item_data,
			) ;
		
		/*	     $data["channel"] = array(
		 "title" => $xoopsConfig['sitename']." - ". $modinfo->name(),
		 "link"  => sprintf('%s/modules/%s/', XOOPS_URL , $modinfo->dirname()) ,
		 "description" => $xoopsMetaConfig['meta_description'],
		 "dc:language" => _LANGCODE ,
		 "dc:creator" => $xoopsMetaConfig['meta_author'],
		 "entry" => $item_data,
		 );
		 */	     
		require_once 'XML/Serializer.php' ;
		$Serializer = &new XML_Serializer($options);
		$status = $Serializer->serialize($data);
		if (PEAR::isError($status)){
			die($status->getMessage());
		}
		
		return $Serializer->getSerializedData();
	}
}
// }}}

// {{{ Xanhte_Rss
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */
class Xanhte_Rss extends Ethna_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥
	 */
	var	$table_def = array();

	var	$prop_def = array();

        var     $table_join = array();
	/**#@-*/

	/**
	 *	Xanhte_Rss饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_Rss(&$backend, $key_type = null, $key = null, $prop = null, $table_def=null, $prop_def=null, $table_join=null )
	{
	    // Ethna_AppObjectΥץѥƥͿ
	    if( is_array($table_def) ){
		$this->table_def = $table_def ;
	    }
	    if( is_array($prop_def) ){
		$this->prop_def = $prop_def ;
	    }
	    if( is_array($table_join) ){
		$this->table_join = $table_join ;
	    }
	    $r = parent::Ethna_AppObject($backend, $key_type, $key, $prop);
	    if (Ethna::isError($r)) {
		return $r;
	    }
	    // ֥ȼԤϤ˵Ҥޤ
	}

        /**
	 *	ơ֥른祤
	 *
	 *	@access	public
	 *	@param	string	$table_name	ꤹơ֥
	 *	@param	array	$table_prop	ơ֥ץѥƥ
	 *	@return	null
	 */
	function _SQLPlugin_SearchTable()
	{
	    $join_query = '';
	    if( is_array($this->table_join) ){
		foreach($this->table_join as $right_table => $join_def){
		    $join_query .= " left join $right_table ON " ;
		    list($l, $r) = each($join_def) ;
		    $join_query .= sprintf(' %s=%s ', $l, $r);
		}
	    }
	    return $join_query;
	}

        // Dummy
        function _isAdditionalField($v){
	    return true ;
	}
	/**
	 *	ơ֥ؤΥ(W)
	 *
	 *	@access	public
	 *	@param	string	$table_name	ꤹơ֥
	 *	@param	array	$table_prop	ơ֥ץѥƥ
	 *	@return	null
	 */
	function setTable($table_name, $table_prop)
	{
		if( is_string($table_name) && is_array($table_prop)){
			$this->table_def[$table_name] = $table_prop ;
		}
	}
	
	/**
	 *	եؤΥ(W)
	 *
	 *	@access	public
	 *	@param	string	$prop_field	ꤹץѥƥ̾
	 *	@param	array	$prop_prop	ץѥƥ
	 *	@return	null
	 */
	function setProp($prop_field, $properties)
	{
		if( is_string($prop_field) && is_array($properties)){
			$this->prop_def[$prop_field] = array(
				'primary' => $properties['primary'],
				'key' => $properties['key'], 
				'type' => $properties['type'], 
				'form_name' => $properties['form_name'],
				'prop_name' => $properties['prop_name'] ,
			) ;
		}
	}
	
	/**
	 *	桼ץѥƥɽؤΥ
	 *
	 *	@access	public
	 *	@param	string	$key	桼ץѥƥ̾
	 *	@return	mixed	$keyǻꤷ桼ץѥƥ
	 */
	function getName($key)
	{
		return $this->get($key);
	}

	/**
	 *	桼ץѥƥɽ̾ǼϢ
	 *
	 *	@access	public
	 *	@return	array	桼ץѥƥɽ̾ǼϢ
	 */
	function getNameObject()
	{
		$object = parent::getNameObject();

		return $object;
	}
	
	/**
	 *	ץѥƥܺ̾Ǽ°ϢǼ
	 *
	 *	@access	public
	 *	@return	array	ץѥƥܺ̾ǼϢ
	 */
	function getNameProp()
	{
		$object = array();

		foreach ($this->prop_def as $key => $elt) {
			$object[$key] = isset($elt['prop_name']) ? $elt['prop_name'] : '' ;
		}

		return $object;
	}


}
// }}}

?>
