<?php
// vim: foldmethod=marker
/**
CREATE TABLE bb_topics (
  topic_id int(8) unsigned NOT NULL auto_increment,
  topic_title varchar(255) default NULL,
  topic_poster int(5) NOT NULL default '0',
  topic_time int(10) NOT NULL default '0',
  topic_views int(5) NOT NULL default '0',
  topic_replies int(4) NOT NULL default '0',
  topic_last_post_id int(8) unsigned NOT NULL default '0',
  forum_id int(4) NOT NULL default '0',
  topic_status tinyint(1) NOT NULL default '0',
  topic_sticky tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (topic_id),
  KEY forum_id (forum_id),
  KEY topic_last_post_id (topic_last_post_id),
  KEY topic_poster (topic_poster),
  KEY topic_forum (topic_id,forum_id),
  KEY topic_sticky (topic_sticky)
) TYPE=MyISAM;

 *	
 *
 *	@author		ITOH Takashi
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_NewbbTopics
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		ITOH Takashi
 *	@access		public
 *	@package	Sample
 */

class Xanhte_NewbbTopicsManager extends Xanhte_AppManager
{
	
	/***
	 *	// ƥɲ
	 * @access public
	 * @param string $cat_title ƥΥȥ
	 * @return array $prop ץѥƥ
	 */
	function addTopics($cat_title){
		// get Max order
		$prop = $this->getMaxTopicsOrderProp();
		$cat_order = isset($prop['cat_order']) ? $prop['cat_order'] : 0;
		$prop = array(
			'cat_id' => '',
			'cat_title'=> $cat_title,
			'cat_order' => $cat_order,
			) ;
		$category = new Xanhte_NewbbTopics(&$this->backend, null, null, $prop);
		if( $category->add() === 0 ){
			$ret = intval($category->get('cat_id'));
		}else{
			$ret = false ;
		}
		return $ret ;
	}
	
	
		
	/***
	 * ȥԥåIDǥȥԥå(new ǤʤJOINξ)
	 * @access public
	 * @param int $topic_id ȥԥåID
	 * @return array ȥԥåΥץѥƥ
	 */
	function getTopicInformation($topic_id){
	
		$filter = array(
			'topic_id' => new Ethna_AppSearchObject($topic_id, OBJECT_CONDITION_EQ), 
			'post_time' => new Ethna_AppSearchObject(0, OBJECT_CONDITION_GT), 
			);
		$topic =& $this->getObjectProp('NewbbTopics', null, $filter);
		
		return $topic ;
	}
	
	/***
	 * IDǥȥԥå
	 * @access public
	 * @param int $post_id ID
	 * @return object ȥԥåobject
	 */
	function getTopicByPostId($post_id){
		
		$post = new Xanhte_NewbbPosts(&$this->backend, 'post_id', $post_id);
		$topic = new Xanhte_NewbbTopic(&$this->backend, 'topic_id', $post->get('topic_id'));
		
		return $topic ;
	}
	
	
	

	
	/***
	 * ȥԥåեID
	 * af->'sortsince' / af->'sortorder' / af->'sortname' / af->'page' ˰¸ޤ
	 *
	 * @access public
	 * @param int $forum_id եID
	 * @return array 0=> 1=>ġΥȥԥå
	 */
	function getTopicsByForumId($forum_id){
		
		$filter = array();
		$now = time();
		
		if ($forum_id){
			$filter['forum_id'] = new Ethna_AppSearchObject($forum_id, OBJECT_CONDITION_EQ);
		}
		if ($this->af->get('sortsince')){
			$last_post_limit = $now - $this->af->get('sortsince')*86400 ;
			$filter['post_time'] = new Ethna_AppSearchObject($last_post_limit, OBJECT_CONDITION_GT);
		}
		
		$asc = ($this->af->get('sortorder')===OBJECT_SORT_ASC||$this->af->get('sortorder')==OBJECT_SORT_DESC) ? $this->af->get('sortorder') : OBJECT_SORT_DESC ;

		switch ($this->af->get('sortname')){
		  case 'topic_replies' :  case 'topic_title' :  case 'uname' :  case 'topic_views' :  case 'post_time' :
			break ;
		  default :
			$this->af->set('sortname', 'post_time');
		}
		$order = array($this->af->get('sortname') => $asc);
		
		$forum = $forum_id ? new Xanhte_NewbbForum(&$this->backend, 'forum_id', $forum_id) : new Xanhte_NewbbForum(&$this->backend) ;
		$limit = $forum ? $forum->get('topics_per_page') : 20 ;
		$offset = $this->af->get('page') ? $limit*($this->af->get('page')-1) : 0 ;
		
		$topics =& $this->getObjectPropList('NewbbTopics', null, $filter, $order, $offset, $limit);
		
		return $topics ;
	}
	
	
	/***
	 * ǶƤΤäȥԥå(֥å)
	 *
	 * @access public
	 * @param int $num ȥԥå
	 * @param array $order getObjectPropListϤOrder
	 * @param bool ץ饤١ȥե⡼
	 * @return array ȥԥåΰ
	 */
	function getRecentTopic($num, $order=array('post_time'=>OBJECT_SORT_DESC), $isPrivate=false){
		
		$forums = $this->newbbF->getReadableForum(false, $isPrivate); // ɤե
		
		if (count($forums)==0) return array(0, array());
		
		$forum_id = array();
		$forum_prop = array();
		foreach ($forums as $f){
			$forum_id[] = $f['forum_id'] ;
			$forum_prop[$f['forum_id']] = $f;
		}
		
		$filter = array('forum_id' => new Ethna_AppSearchObject($forum_id, OBJECT_CONDITION_EQ)) ;
		$topics = $this->getObjectPropList('NewbbTopics', null, $filter, $order, 0, $num);
		
		if (Ethna::isError($topics)){
			$topics = array();
		}
		
		foreach ($topics[1] as $k=>$t){
			$topics[1][$k]['forum'] = $forum_prop[$t['forum_id']];
		}
		
		return $topics ;
	}
	
	
	
	
	/***
	 * ȥԥåΥڡ
	 *
	 * @access public
	 * @param array $topic ȥԥåProp
	 * @param int $posts_per_page 1ڡɽƿ
	 * @param array $pager_conf ڡConf(PEAR::Pager)
	 * @return array Xanhte_Util::createPager()֤ΤƱ
	 */
	function getTopicPager($topic, $posts_per_page, $pager_conf=null){
	
		$ethna_config = $this->backend->getConfig();
		
		if ($pager_conf){
			$ethna_config->set('pager', $pager_conf);
		}
		
		$pager =  Xanhte_Util::createPager($ethna_config, $topic['topic_replies'], $posts_per_page) ;
		
		return $pager['links'];
	}
	
	/***
	 * ΥȥԥåΤ
	 
	 * @access protected
	 * @param int $forum_id եID
	 * @param int $topic_created ȥԥåκ
	 * @param bool $prev 
	 * @return int
	 */
	function _getNextPreviousTopic($forum_id, $topic_created, $prev=true){
		
		$filter = array(
			'forum_id' => new Ethna_AppSearchObject($forum_id, OBJECT_CONDITION_EQ),
			'topic_time' => new Ethna_AppSearchObject($topic_created, $prev ? OBJECT_CONDITION_LT : OBJECT_CONDITION_GT),
			);
		$order = array('topic_time' => $prev ? OBJECT_SORT_DESC : OBJECT_SORT_ASC);
		$topics = $this->getObjectPropList('NewbbTopics', null, $filter , $order , 0, 1);
		
		return isset($topics[1][0]) ? $topics[1][0] : array() ;
	}

	
	/***
	 * ΥȥԥåΤ
	 
	 * @access public
	 * @param int $forum_id եID
	 * @param int $topic_created ȥԥåκ
	 * @return int
	 */
	function getPreviousTopic($forum_id, $topic_created){
		return $this->_getNextPreviousTopic($forum_id, $topic_created, true);
	}

	
	/***
	 * ǸΥȥԥåΤ
	 
	 * @access public
	 * @param int $forum_id եID
	 * @param int $topic_created ȥԥåκ
	 * @return int
	 */
	function getNextTopic($forum_id, $topic_created){
		return $this->_getNextPreviousTopic($forum_id, $topic_created, false);
	}

	
	/***
	 * COOKIE򸵤ˡΥȥԥåɤå
	 
	 * @access public
	 * @param int $topic_id ȥԥåID
	 * @param int $topic_last_post_time ȥԥåκǽƻ
	 * @return bool true:Ƥ false:ǤϤʤ
	 */
	function isNewTopic($topic_id, $topic_last_post_time){
	
		$topic_lastread = $this->unSerializeTopicReadCookie();
		
		if (isset($topic_lastread[$topic_id])){
			if ($topic_lastread[$topic_id] > $topic_last_post_time){
				return false ;
			}
		}
		
		return true ;
	}

	
	/***
	 * ȥԥåФֿΤʿ碌ΤȤ˻Ȥ
	 
	 * @access public
	 * @return int
	 */
	function getTopicsReplies(){
	}
	
	
	/***
	 * ȥԥåΤ
	 
	 * @access public
	 * @return int
	 */
	function getTotalTopics(){
	
		global $xoopsDB ;
		
		$db =& $this->backend->getDB();
		$sql = sprintf('select count(*) as c from %s', $xoopsDB->prefix('bb_topics'));
		if ($re = $db->query($sql)){
			$ret = $re->fetchRow();
			return $ret['c'];
		}
		return 0 ;
	}
	
	
	/***
	 * ȥԥåIDǥץ饤١ȥեޤƥեΥå
	 * @access public
	 * @param int $topic_id ȥԥåID
	 * @param bool $isWrite trueʤ񤭹߸¤θ֤
	 * @return bool
	 */
	function checkPrivilegeByTopicId($topic_id, $isWrite=true){
	
		if (!$topic_id) return false ;
	
		$topic = new Xanhte_NewbbTopics(&$this->backend, 'topic_id', $topic_id);
		
		return $this->newbbF->checkPrivilegeByForumId($topic->get('forum_id'), $isWrite);
	}




	/***
	 * ΥȥԥåIDδCOOKIE
	 *
	 * @access public
	 * @return array
	 */
	function unSerializeTopicReadCookie($time_threshold=300){
		
		static $topic_lastread ;
		
		if (isset($topic_lastread) && is_array($topic_lastread)){
			return $topic_lastread ;
		}
		
		if (!isset($_COOKIE['newbb_topic_lastread']) || empty($_COOKIE['newbb_topic_lastread'])){
			$topic_lastread = array();
		} else {
			$topic_lastreadtmp = explode( ',' , $_COOKIE['newbb_topic_lastread'] ) ;
			foreach ($topic_lastreadtmp as $tmp) {
				$idtime = explode( '|' , $tmp ) ;
				$id = empty( $idtime[0] ) ? 0 : intval( $idtime[0] ) ;
				$time = empty( $idtime[1] ) ? 0 : intval( $idtime[1] ) ;
				$topic_lastread[ $id ] = $time*$time_threshold;
			}
		}
		
		return $topic_lastread ;
	}
	
	
	
	/***
	 * ΥȥԥåIDɤȤCOOKIE˻Ĥ
	 *
	 * @access public
	 * @param int $topic_id ȥԥåID
	 * @param int $time_threshold ðƱȤߤʤ
	 * @return null
	 */
	function saveTopichasRead($topic_id, $time_threshold=300){
		
		$topic_lastread = $this->unSerializeTopicReadCookie($time_threshold);
		
		$time = time();
		if (isset($topic_lastread[$topic_id])){
			if ($topic_lastread[$topic_id] >= $time){
				return null ;
			}
		}
		
		$topic_lastread[$topic_id] = $time;
		
		$record_str = $this->_serializeTopicReadCookie($topic_lastread, $time_threshold);
		
		$xoops_info = parse_url(XOOPS_URL);
		$url_info = parse_url($_SERVER['REQUEST_URI']);
		setcookie("newbb_topic_lastread", $record_str , time()+365*24*3600, dirname($url_info['path']), $xoops_info['host']);
	}
	
	
	/***
	 * ΥȥԥåIDα1夲
	 *
	 * @access public
	 * @param int $topic_id ȥԥåID
	 * @return null
	 */
	function increaseTopicView($topic_id){
		
		$db =& $this->backend->getDB();
		$sql = sprintf('update %s set topic_views=topic_views+1 where topic_id=%d', $GLOBALS['xoopsDB']->prefix('bb_topics'), $topic_id);
		$db->queryF($sql);
		
		return null ;
	}
	
	
	/***
	 * NewbbɴäΥꥢ饤ˡʸľ
	 *
	 * @access private
	 * @param array $topic_lastread ɾ
	 * @return string ꥢ饤줿ʸ
	 */
	function _serializeTopicReadCookie($topic_lastread, $time_threshold=300){
		
		$counter = 150000/$time_threshold ; // $time_threshold300λ500¸Ǥ(COOKIE̤4kbȤserializeˡο¬)ȤȤ150000
		
		$str4cookie = '' ;
		foreach( $topic_lastread as $id => $time ) {
			$str4cookie .= intval($id) . '|' . intval($time/$time_threshold) . ',' ;
			if( -- $counter < 0 ) break ;
		}
		$str4cookie = substr( $str4cookie , 0 , -1 ) ;
		
		return $str4cookie ;
	}
	

}
// }}}

// {{{ Xanhte_Topics
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */
class Xanhte_NewbbTopics extends Xanhte_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥
	 */
        var $table_def = array(
			'bb_topics' => array(
				'primary' => true 
				)
			);
	
        var $prop_def = array(
			'topic_id'=> array(
				'primary' => true,
				'key' => true,
				'seq' => true,
				'type' => VAR_TYPE_INT,
				'form_name' => 'topic_id',
				'prop_name' => 'ȥԥåID' ,
				),
			'topic_title'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'topic_title',
				'prop_name' => 'ȥԥå̾' ,
				),
			'topic_poster'=> array(
				'primary' => false,
				'key' => true,
				'type' => VAR_TYPE_INT,
				'form_name' => 'topic_poster',
				'prop_name' => 'ȥԥåΩƤ' ,
				),
			'topic_time'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'topic_time',
				'prop_name' => 'ȥԥåΩƤ' ,
				),
			'topic_views'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'topic_views',
				'prop_name' => 'ȥԥå' ,
				),
			'topic_replies'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'topic_replies',
				'prop_name' => 'ȥԥåֿ' ,
				),
			'topic_last_post_id'=> array(
				'primary' => false,
				'key' => true,
				'type' => VAR_TYPE_INT,
				'form_name' => 'topic_title',
				'prop_name' => 'ȥԥåǽ쥹ο' ,
				),
			'forum_id'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'forum_id',
				'prop_name' => 'ȥԥåΥեID' ,
				),
			'topic_status'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'topic_status',
				'prop_name' => 'ȥԥåξ' ,
				),
			'topic_sticky'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'topic_sticky',
				'prop_name' => 'ȥԥå' ,
				),
			);
	
	/**#@-*/	    
	
	/**#@-*/
	
	/**
	 *	Xeblog_Entry饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_NewbbTopics(&$backend, $key_type = null, $key = null, $prop = null)
	{
		$this->Xanhte_AppObject(&$backend, $key_type, $key, $prop);
	    // ֥ȼԤϤ˵Ҥޤ
	}
	
	
	/**
	 * ֥ȸSQLץ饰(ɲþ)
	 *
	 * sample:
	 * <code>
	 * $search_prop_def = array(
	 * 'group_id' => array(
	 * 'primary' => true, 'key' => true, 'type' => VAR_TYPE_INT,
	 * 'form_name' => 'group_id', 'table' => 'group_user_tbl',
	 * ),
	 * );
	 * return $search_prop_def;
	 * </code>
	 *
	 * @access protected
	 * @return array ɲþ
	 */
	function _SQLPlugin_SearchPropDef(){
		$search_prop_def = array(
			'uname' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			'post_time' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_bb_posts',
				),
			'icon' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_bb_posts',
				),
			'uid as last_post_uid' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_bb_posts',
				),
			);
			
		return $search_prop_def ;
	}
	

	/**
	 * ֥ȸSQLץ饰(ɲåơ֥)
	 *
	 * sample:
	 * <code>
	 * return " LEFT JOIN bar_tbl ON foo_tbl.user_id=bar_tbl.user_id";
	 * </code>
	 *
	 * @access protected
	 * @return string ơ֥JOINSQLʸ
	 */

	 
	function _SQLPlugin_SearchTable(){
		
		global $xoopsDB;
		
		return sprintf("LEFT JOIN %s ON topic_poster=%s.uid LEFT JOIN %s ON topic_last_post_id=post_id ",
					   $xoopsDB->prefix('users'), $xoopsDB->prefix('users'), $xoopsDB->prefix('bb_posts'));
	}


		
	

}
// }}}

?>
